'use strict';

const Service = require('egg').Service;

class ScheduleService extends Service {
  async appKeylist() {
    const { ctx } = this;
    const appKeylists = new Map();
    const ret = await ctx.model.NodeLimit.findAll({
      attributes: ['appKey', 'text2', 'currentCount', 'limitCount', 'customerUrl'],
      where: { type: 'thxd' },
    });
    if (ret.length > 0) {
      ret.map(customer => {
        appKeylists.set(customer.appKey, {
          text2: customer.text2,
          customerUrl: customer.customerUrl,
        });
      });
      ctx.app.appKeylists = appKeylists;
    }
  }
}

module.exports = ScheduleService;
