'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const nodeLimit = app.model.define('nodeLimit', {
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      field: 'id',
    },
    appKey: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: '',
      field: 'appKey',
    },
    type: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'type',
    },
    currentCount: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'currentCount',
    },
    limitCount: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'limitCount',
    },
    customerUrl: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'customerUrl',
    },
    createTime: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'createTime',
    },
    updateTime: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'updateTime',
    },
    text: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'text',
    },
    text2: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'text2',
    },
  },
  {
    tableName: 'node_limit',
    timestamps: false,
  });

  return nodeLimit;
};
