'use strict';

const Service = require('egg').Service;

class SignatureService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    const { signatureAPI, lockKeys } = config;

    this.baseURL = signatureAPI.host;
    this.fetchTokenUrl = signatureAPI.fetchTokenUrl;
    this.fetchOrderIdUrl = signatureAPI.fetchOrderIdUrl;
    this.signatureUrl = signatureAPI.signatureUrl;
    this.signatureType = signatureAPI.signatureType;
    this.LOCK_KEY = lockKeys.fecteToken;
    this.SCRIPTS_KEY = lockKeys.token;

  }

  _request(url, opts) {
    const { ctx, baseURL } = this;
    url = `${baseURL}${url}`;
    opts = {
      charset: 'utf-8',
      timeout: [30000, 30000],
      dataType: 'json',
      ...opts,
    };
    ctx.logger.info('signnature', url, opts);
    return ctx.curl(url, opts);
  }

  _checkSuccess(result) {
    if (result.status !== 200) {
      const errorMsg = result.data && result.data.error_msg ? result.data.error_msg : 'unknown error';
      this.ctx.throw(result.status, errorMsg);
    }
    if (result.data.code !== 0) {
      this.ctx.throw(400, { message: result.data.msg, code: result.data.code });
    }
  }

  async createToken(params) {
    const { fetchTokenUrl, ctx } = this;
    const result = await this._request(fetchTokenUrl, {
      method: 'post',
      data: params,
      contentType: 'json',
    });
    ctx.logger.info('【Signature】createToken params', JSON.stringify(params), 'result:', JSON.stringify(result.data));
    this._checkSuccess(result);
    return result.data.data.token;
  }

  async createOrderId(params) {
    const { fetchOrderIdUrl, ctx } = this;
    const result = await this._request(fetchOrderIdUrl, {
      method: 'post',
      data: params,
      contentType: 'json',
    });
    ctx.logger.info('【Signature】createOrderId params', JSON.stringify(params), 'result:', JSON.stringify(result.data));
    this._checkSuccess(result);
    return result.data.data.orderSn;
  }

  async signatureCheck(params) {
    const { signatureUrl, signatureType, ctx } = this;
    const result = await this._request(signatureUrl, {
      method: 'post',
      data: { ...params, type: signatureType },
      contentType: 'json',
    });
    ctx.logger.info('【Signature】signatureCheck params', JSON.stringify(params), 'result:', JSON.stringify(result.data));
    this._checkSuccess(result);
    return result.data.data;

  }
}

module.exports = SignatureService;
