'use strict';
$.progress = (function() {
  function _(option) {
  }

  _.prototype = {
    start(container) {
      const self = this;
      const loader = $('<div>', { class: 'progress-top-loader' }).appendTo(container ? container : $('body'));
      this._progress = 0;
      this._completed = false;
      loader.addClass('out');
      window.requestAnimFrame = (function() {
        return window.requestAnimationFrame ||
          window.webkitRequestAnimationFrame ||
          window.mozRequestAnimationFrame ||
          window.oRequestAnimationFrame ||
          window.msRequestAnimationFrame ||
          function(callback) {
            window.setTimeout(callback, 1000 / 60);
          };
      })();
      function rand(a, b) {
        return Math.round(a + Math.random() * (b - a));
      }
      function mix(a, b, r) {
        return a + (b - a) * r;
      }
      function easing(k) {
        if ((k *= 2) < 1) {
          return 0.5 * k * k * k;
        }
        return 0.5 * ((k -= 2) * k * k + 2);
      }
      let times = rand(1, 3),
        elapsed_time = 0,
        queue = [],
        top,
        last_time = +new Date(),
        target = 20;
      for (let i = 0; i < times; i++) {
        target = rand(target, 40 + 20 * i);
        queue.push({
          duration: rand(500, 6000 - i * 2000),
          target,
          type: 'play',
        });
        queue.push({
          duration: rand(500, 2000 + i * 2000),
          type: 'pause',
        });
      }
      top = queue.shift();
      top.src = self._progress;

      function animationLoop() {
        do {
          if (self._completed) {
            queue = [];
            top = { src: self._progress, target: 100, type: 'play', duration: 400 };
            elapsed_time = 0;
            last_time = +new Date();
            delete self._completed;
          } else if (elapsed_time <= top.duration) {
            if (top.type == 'play') {
              self._progress = parseFloat(mix(top.src, top.target, easing(elapsed_time / top.duration)).toFixed(2));
            }
          } else {
            elapsed_time = 0;
            if (queue.length) {
              if (top.type == 'play') {
                self._progress = top.target;
              }
              top = queue.shift();
              top.src = self._progress;
            } else {
              if (self._progress >= 99) {
                loader.css('width', self._progress + '%');
                loader.removeClass('out');
                setTimeout(function() {
                  loader.detach();
                }, 200);
                return;
              }
            }
          }
          if (!isNaN(self._progress)) {
            loader.css('width', self._progress + '%');
          }

        } while (false);

        const current_time = +new Date();
        elapsed_time += current_time - last_time;
        last_time = current_time;

        requestAnimFrame(animationLoop);
      }
      animationLoop();
      return self;
    },
    end() {
      this._completed = true;
      return self;
    },
  };

  return _;
})();
$.prompt = function(text, delay) {
  if (delay === undefined || +delay <= 0) {
    delay = 3000;
  }
  let prompt = $('#prompt'),
    timer = 0;
  if (prompt.length === 0) {
    prompt = $('<div>', { class: 'prompt', id: 'prompt' }).append($('<span>')).appendTo($('body'));
  }
  prompt.find('span').html(text);
  timer = prompt.data('timer');
  timer && clearTimeout(timer);
  prompt.show();
  prompt.data('timer', setTimeout(function() {
    prompt.detach().data('timer', 0);
  }, delay));
};

$.toast = function(text, delay) {
  if (delay === undefined || +delay <= 0) {
    delay = 3000;
  }
  let toast = $('#toast'),
    timer = 0;
  if (toast.length === 0) {
    toast = $('<div>', { class: 'toast', id: 'toast' }).append($('<span>')).appendTo($('body'));
  }
  toast.find('span').html(text);
  timer = toast.data('timer');
  timer && clearTimeout(timer);
  toast.show();
  toast.data('timer', setTimeout(function() {
    toast.detach().data('timer', 0);
  }, delay));
};

$.dialog = (function() {
  function _(option) {
    function get_param(a, b, c) {
      return b in a ? a[b] : c;
    }
    let title = get_param(option, 'title'),
      content = get_param(option, 'content'),
      style = get_param(option, 'style', {}),
      buttons = get_param(option, 'buttons', [{ title: '确认' }]);

    if ('html' in option) {
      content = option.html;
    } else if ('content' in option) {
      content = (function htmlEncode(str) {
        const div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
      })(option.content);
    }
    const self = this;
    this.context = $(['<div class="dialog">',
      '<div class="dialog-title"></div>',
      '<div class="dialog-wrapper">',
      '<div class="dialog-content">',
      '</div>',
      '<div class="dialog-button-container">',
      '</div>',
      '</div>',
      '</div>'].join(''));

    this.context.find('.dialog-title')[title ? 'html' : 'detach'](title);

    for (let i = 0; i < buttons.length; i++) {
      const a = buttons[i];
      this.add(get_param(a, 'title', '提示'), get_param(a, 'className'), get_param(a, 'tap'));
    }
    this.content = this.context.find('.dialog-content');
    if (content) {
      this.content.append(content);
    } else {
      this.content.empty();
    }
    for (let key in style) {
      key = key.replace(/([A-Z])/g, '-$1').toLowerCase();
      const ele = key == 'root' ? this.context : this.context.find('.dialog-' + key);
      const css = style[key];
      if (typeof css === 'string') {
        ele.addClass(css);
      } else if (typeof css === 'object') {
        ele.css(css);
      }
    }
    this._loaded = false;
    this._alert = false;
    this._listeners = {};
  }
  _.prototype = {
    dismiss() {
      const self = this;
      self.trigger('dimiss');
      this.context.removeClass('out');
      $.dialog.global.blocking = false;
      const overlay = $('.ui-overlay').removeClass('out');
      setTimeout(function() {
        overlay.removeClass('show');
        self.context.removeClass('show');
        self.trigger('hide');
        self.context.detach();
      }, 200);
      return this;
    },
    on(type, fn) {
      type = type.replace(/^\s*|\s*$/gi, '');
      if (/\s+/.test(type)) {
        type.split(/\s+/).forEach(function(v, k) {
          this.on(v, fn);
        }, this);
        return this;
      }
      if (typeof this._listeners[type] === 'undefined') {
        this._listeners[type] = [];
      }
      if (typeof fn === 'function') {
        this._listeners[type].push(fn);
      }
      return this;
    },
    off(type, fn) {
      type = type.replace(/^\s*|\s*$/gi, '');
      if (/\s+/.test(type)) {
        type.split(/\s+/).forEach(function(v, k) {
          this.on(v, fn);
        }, this);
        return this;
      }
      const arrayEvent = this._listeners[type];
      if (typeof type === 'string' && arrayEvent instanceof Array) {
        if (typeof fn === 'function') {
          // 清除当前type类型事件下对应fn方法
          for (let i = 0, length = arrayEvent.length; i < length; i += 1) {
            if (arrayEvent[i] === fn) {
              this._listeners[type].splice(i, 1);
              break;
            }
          }
        } else {
          // 如果仅仅参数type, 或参数fn邪魔外道，则所有type类型事件清除
          delete this._listeners[type];
        }
      }
      return this;
    },
    trigger(type) {
      type = type.replace(/^\s*|\s*$/gi, '');
      const args = Array.prototype.slice.call(arguments, 0);
      args.unshift(document.createEvent('HTMLEvents'));
      args[0].initEvent(type);
      const arrayEvent = this._listeners[type];
      if (arrayEvent instanceof Array) {
        for (let i = 0, length = arrayEvent.length; i < length; i += 1) {
          if (typeof arrayEvent[i] === 'function') {
            arrayEvent[i].apply(this, args);
          }
        }
      }
      return this;
    },
    addClass(className) {
      this.context.addClass(className);
      return this;
    },
    attr() {
      return this.context.attr.apply(this.context, Array.prototype.slice.call(arguments, 0));
    },
    find(selector) {
      return this.content.find(selector);
    },
    $(selector) {
      return this.find(selector);
    },
    model() {
      let self = this,
        opt = {},
        args = Array.prototype.slice.call(arguments, 0);
      [{
        name: 'alert',
        default_value: false,
      }, {
        name: 'animated',
        default_value: true,
      }].forEach(function(item, index) {
        opt[item.name] = index < args.length ? args[index] : item.default_value;
      });
      this._alert = opt.alert;
      if ($.dialog.global.blocking) {
        $.dialog.global.queue.push(function() {
          self.model.apply(self, args);
        });
        return this;
      }
      $.dialog.global.blocking = true;
      this._loaded == false && this.trigger('load'), this._loaded = true;
      let overlay = $('.ui-overlay');
      overlay.length == 0 && (overlay = $('<div>', { class: 'ui-overlay' }).appendTo($('body')));
      overlay.off('click').on('click', function() {
        if (self._alert) {
          return;
        }
        // self.dismiss();
      });
      const classNames = opt.animated ? ['show', 'out'] : ['out', 'show'];
      overlay.addClass(classNames[0]);
      this.trigger('show');
      this.context.appendTo($('body')).addClass(classNames[0]);
      setTimeout(function() {
        self.context.addClass(classNames[1]);
        overlay.addClass(classNames[1]);
        self.trigger('model');
      }, 10);
      return this;
    },
    alert() {
      return this.model(true);
    },
    wrap(title, className, func) {
      return this.context.find('.dialog-button-container').empty(), this.add(title, className, func);
    },
    add(title, className, func) {
      const self = this;
      let btns = self.context.find('.dialog-button');
      btns.removeClass('d-' + btns.length);
      return (btns = btns.add($('<button>', { class: 'dialog-button' }).addClass(className).html(title)
        .on('click', function() {
          const i = $(this).index();
          const event = document.createEvent('HTMLEvents');
          event.initEvent('tap');
          (typeof func === 'function' && func.apply(self, [event, this])) || self.dismiss();
          self.trigger('submit', i);
        }))), this.context.find('.dialog-button-container').empty().append(btns.addClass('d-' + btns.length)), this;
    },
  };
  return function() {
    let option = {};
    if (arguments.length == 1) {
      if (typeof arguments[0] === 'string') {
        option.html = arguments[0];
      } else if (typeof arguments[0] === 'object') {
        option = arguments[0];
      }
    } else if (arguments.length >= 2) {
      option.title = arguments[0];
      option.html = arguments[1];
    } else {

    }
    return new _(option);
  };
})();

$.dialog.global = (function() {
  let blocking = false;
  const global = { queue: [], clear() {
    this.queue = [];
    blocking = false;
  } };

  Object.defineProperty(global, 'blocking', {
    enumerable: true,
    configurable: true,
    get: function reactiveGetter() {
      return blocking;
    },
    set: function reactiveSetter(newVal) {
      newVal = !!newVal;
      blocking = newVal;
      if (!newVal) {
        if (global.queue.length) {
          const fn = global.queue.shift();
          fn();
        }
      }
    },
  });

  return global;
})();
