'use strict';

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const taskStatus = app.model.define('taskStatus', {
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      field: 'id',
    },
    orderId: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'order_sn',
    },
    taskId: {
      type: DataTypes.STRING(50),
      allowNull: true,
      field: 'task_id',
    },
    phone: {
      type: DataTypes.STRING(11),
      allowNull: true,
      field: 'phone',
    },
    city: {
      type: DataTypes.STRING(20),
      allowNull: true,
      field: 'city',
    },
    operator: {
      type: DataTypes.STRING(10),
      allowNull: true,
      field: 'operator',
    },
    appkey: {
      type: DataTypes.STRING(50),
      allowNull: false,
      field: 'app_key',
    },
    status: {
      type: DataTypes.STRING(20),
      allowNull: true,
      field: 'status',
    },
    note: {
      type: DataTypes.STRING(8000),
      allowNull: true,
      field: 'note',
      get() {
        const note = this.getDataValue('note');
        if (note) {
          try {
            return JSON.parse(note);
          } catch (error) {
            return {};
          }
        }
        return {};
      },
      set(val) {
        this.setDataValue('note', JSON.stringify(val));
      },
    },
    params: {
      type: DataTypes.STRING(8000),
      allowNull: true,
      field: 'params',
      get() {
        const note = this.getDataValue('params');
        if (note) {
          try {
            return JSON.parse(note);
          } catch (error) {
            return {};
          }
        }
        return {};
      },
      set(val) {
        this.setDataValue('params', JSON.stringify(val));
      },
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'create_time',
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: app.Sequelize.literal('CURRENT_TIMESTAMP'),
      field: 'update_time',
    },
    msg: {
      type: DataTypes.STRING(255),
      allowNull: true,
      field: 'msg',
    },
    remark: {
      type: DataTypes.STRING(255),
      allowNull: true,
      field: 'remark',
    },
  },
  {
    tableName: 'thxd_status',
  });

  return taskStatus;
};
