'use strict';

const Service = require('egg').Service;

class OrderService extends Service {
  async getOneByOrderId(params) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findOne({
      where: params,
    });
    return order;
  }
  async getOneByTaskId(taskId) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findOne({
      where: { taskId },
    });
    return order;
  }

  async create(params) {
    const { ctx } = this;
    await ctx.model.TaskStatus.create(params);
    return;
  }

  async getOneByParams(where){
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findAll({
      where,
    });
    if (order.length === 0) {
      ctx.throw(400, { message: 'no orderId' });
      return;
    }
    if (order.length > 1) {
      ctx.throw(400, { message: 'error orderId or taskId' });
      return;
    }
    return order[0];
  }

  /*
    @desc 更新task
  */
  async update(data, where) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findAll({
      where,
    });
    if (order.length === 0) {
      ctx.throw(400, { message: 'no orderId' });
      return;
    }
    if (order.length > 1) {
      ctx.throw(400, { message: 'error orderId or taskId' });
      return;
    }
    for (const item of order) {
      if (item.status === 'success') {
        ctx.throw(400, { message: 'orderId success' });
        return;
      }
    }
    await order[0].update(data);
    return order[0];
  }
}

module.exports = OrderService;
