'use strict';

const Service = require('egg').Service;

class WashDataService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    this.washUrl = config.washAPI.host + config.washAPI.washUrl;
    this.callbackUrl = config.dataCallbackUrl;
    this.newwashUrl = config.washAPI.newhost + config.washAPI.newwashUrl;
    this.newcallbackUrl = config.newdataCallbackUrl;
  }
  async wash(data, orderId, netMark = 0) {
    const { app, washUrl, ctx } = this;
    const rawdata = {
      data,
      callbackUrl: this.callbackUrl,
      orderId,
      netMark,
    };
    const washData = await app.curl(washUrl,
      {
        charset: 'utf-8',
        timeout: [3000, 3000],
        dataType: 'json',
        data: rawdata,
        method: 'post',
        contentType: 'json',
      });
    if (washData.status !== 200) {
      ctx.logger.error(`【washData】url${washUrl} ,params`, rawdata, washData);
      throw new Error('清洗数据出错');
    }
    return washData.data;
  }

  async newWash(data, orderId, netMark = 0) {
    const { app, newwashUrl, newcallbackUrl, ctx } = this;
    const rawdata = {
      data,
      callbackUrl: newcallbackUrl,
      orderId,
      netMark,
    };
    const washData = await app.curl(newwashUrl,
      {
        charset: 'utf-8',
        timeout: [3000, 3000],
        dataType: 'json',
        data: rawdata,
        method: 'post',
        contentType: 'json',
      });
    if (washData.status !== 200) {
      ctx.logger.error(`【newWashData】url${newwashUrl} ,params`, rawdata, washData);
      throw new Error('new清洗数据出错');
    }
    return washData.data;
  }
}

module.exports = WashDataService;
