'use strict';

const Controller = require('egg').Controller;

class OrderController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.createRule = {
      appKey: 'string',
      userId: {
        type: 'string',
        required: false,
      },
      orderId: {
        type: 'string',
        required: false,
        format: /^(\w{8})-(\w{4})-(\w{4})-(\w{4})-(\w{12})$/,
        message: '订单号格式错误',
      },
      phone: {
        type: 'string',
        format: /^(((13[0-9]{1})|(14[0-9]{1})|(15[4-9]{1})|(16[0-9]{1})|(17[0-9]{1})|(18[0-9]{1})|(19[0-9]{1}))+\d{8})$/,
        message: 'phone格式错误',
        required: true,
      },
      netMark: {
        type: 'number',
        required: false,
      },
    };

    this.showRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          token: 'string',
          orderId: {
            type: 'string',
            required: false,
          },
          orderSn: {
            type: 'string',
            required: false,
          },
          appKey: 'string',
          timestamp: 'string',
        },
      },
    };

    this.fetchRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          appKey: 'string',
          timestamp: 'string',
          token: 'string',
        },
      },
    };
  }


  async fetchOrderId() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.fetchRule);
      const { appKey } = ctx.request.body.params;
      const orderId = await service.signature.createOrderId(ctx.request.body);
      await service.order.create({
        orderId,
        notifyUrl: ctx.app.notifyMap.get(appKey) && ctx.app.notifyMap.get(appKey).notifyUrl || '',
        appKey,
        status: 'init',
      });
      ctx.body = {
        code: 0,
        data: {
          orderSn: orderId,
        },
        msg: '',
      };
    } catch (err) {
      ctx.logger.error('fetchOrderId', JSON.stringify(err));
      ctx.error(err);
    }
  }
}

module.exports = OrderController;
