//document.documentElement.style.fontSize = document.documentElement.clientWidth/25 + 'px';

function getParams(data, key, default_value) {
    if (data != undefined) {
        return key in data ? data[key] : default_value;
    }
    return default_value;
}

function serializeParams(data) {
    var serializedParams = '';
    for (var pro in data) {
        serializedParams += (serializedParams.length ? '&' : '') + pro + '=' + encodeURIComponent(data[pro]);
    }
    return serializedParams;
}

function getURLParams(url) {
    var urlParts = url.split("?");
    var result = {};
    if (urlParts[1]) {
        var params = urlParts[1].split("&");

        for (var i = 0; i < params.length; ++i) {
            var item = params[i].split("=");
            var key = decodeURIComponent(item[0]);
            var uri_encoded = item[1].replace(/%([^\da-fA-f].)/, "%25$1")
            var val = decodeURIComponent(uri_encoded);
            result[key] = val;
        }
    }
    return result;
}


function doAjax(args) {
    var request = new XMLHttpRequest(),
        url = getParams(args, 'url', ''),
        data = getParams(args, 'data', {}),
        contentType = getParams(args, 'contentType', "application/x-www-form-urlencoded"),
        type = getParams(args, 'type', 'get');

    request.onreadystatechange = function () {
        if (request.readyState == 4) {
            if (request.status == 200) {
                var dataType = null;
                if ('dataType' in args) {
                    dataType = args.dataType;
                } else {
                    if (/\bContent\-Type\s*:\s* ([^\n;]+)(?=\n|;)/i.test(request.getAllResponseHeaders())) {
                        var contentType = RegExp.$1;
                        if (/\bjson\b/i.test(contentType)) {
                            dataType = 'json';
                        } else {
                            dataType = 'text';
                        }
                    }
                }
                var data = null;
                if (/^json$/i.test(dataType)) {
                    data = JSON.parse(request.responseText);
                } else {
                    data = request.responseText;
                }
                try {
                    if (typeof args.success == 'function') {
                        args.success(data);
                    }
                } catch (e) {
                }
            } else {
                if (typeof args.error == 'function') {
                    args.error(request.status);
                }
            }
        }
    }
    request.onloadstart = function () {
        if (typeof args.loadstart == 'function') {
            args.loadstart();
        }
    }
    request.onprogress = function (event) {
        if (typeof args.progress == 'function') {
            args.progress(event);
        }
    }
    request.timeout = getParams(args, 'timeout', 0);

    if (/^post$/gi.test(type)) {
        request.open("POST", url, true);
        request.setRequestHeader("Content-Type", contentType);
        if ("application/x-www-form-urlencoded" == contentType) {
            var content = typeof data === 'string' ? data : serializeParams(data);
            request.send(content);
        } else if ("application/json" == contentType) {
            var content = typeof data === 'string' ? data : JSON.stringify(data);
            request.send(content);
        }

    } else {
        url += (url.indexOf("?") >= 0 ? '&' : '?') + serializeParams(data);
        request.open("GET", url, true);
        request.send();
    }
}

function doJsonAjax(url, data, success, failed, loadstart, progress) {
    doAjax({
        url: url,
        type: 'post',
        data: data,
        contentType: 'application/json',
        success: success,
        error: failed,
        loadstart: loadstart,
        progress: progress
    });
}

$.toast = function (text, delay) {
    if (delay === undefined || +delay <= 0) {
        delay = 3000;
    }
    var toast = $('#toast'), timer = 0;
    if (toast.length === 0) {
        toast = $('<div>', {'class': 'toast', id: 'toast'}).append($('<span>')).appendTo($('body'));
    }
    toast.find('span').html(text);
    timer = toast.data('timer');
    timer && clearTimeout(timer);
    toast.show();
    toast.data("timer", setTimeout(function () {
        toast.detach().data("timer", 0);
    }, delay));
}

function IdentityCodeValid(code) {
return true;
    var city = {
        11: "北京",
        12: "天津",
        13: "河北",
        14: "山西",
        15: "内蒙古",
        21: "辽宁",
        22: "吉林",
        23: "黑龙江 ",
        31: "上海",
        32: "江苏",
        33: "浙江",
        34: "安徽",
        35: "福建",
        36: "江西",
        37: "山东",
        41: "河南",
        42: "湖北 ",
        43: "湖南",
        44: "广东",
        45: "广西",
        46: "海南",
        50: "重庆",
        51: "四川",
        52: "贵州",
        53: "云南",
        54: "西藏 ",
        61: "陕西",
        62: "甘肃",
        63: "青海",
        64: "宁夏",
        65: "新疆",
        71: "台湾",
        81: "香港",
        82: "澳门",
        91: "国外 "
    };
    var tip = "";
    var pass = true;

    if (!code || !/^\d{6}(18|19|20)?\d{2}(0[1-9]|1[012])(0[1-9]|[012]\d|3[01])\d{3}(\d|X)$/i.test(code)) {
        tip = "身份证号格式错误";
        pass = false;
    }

    else if (!city[code.substr(0, 2)]) {
        tip = "地址编码错误";
        pass = false;
    } else {
        var t = code.substr(6, 4) + '-' + code.substr(10, 2) + '-' + code.substr(12, 2);
        var ar = t.split(/-/);
        t = new Date(t);
        if (ar[0] != t.getFullYear() || ar[1] != t.getMonth() + 1 || ar[2] != t.getDate()) {
            pass = false;
            tip = "身份证号出生年月错误";
        }
        //18位身份证需要验证最后一位校验位
        if (code.length == 18) {
            code = code.split('');
            //∑(ai×Wi)(mod 11)
            //加权因子
            var factor = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];
            //校验位
            var parity = [1, 0, 'X', 9, 8, 7, 6, 5, 4, 3, 2];
            var sum = 0;
            var ai = 0;
            var wi = 0;
            for (var i = 0; i < 17; i++) {
                ai = code[i];
                wi = factor[i];
                sum += ai * wi;
            }
            if (parity[sum % 11] != code[17]) {
                tip = "校验位错误";
                pass = false;
            }
        }
    }
    if (!pass) $.toast(tip);
    return pass;
}

function apptips(text) {
    var timeout = 2000;
    var tips = $('<div>', {'class': 'tips', id: 'tips'}).append($('<span>')).appendTo($('body'));
    tips.find('span').html(text);
    tips.show();
    tips.data("timer", setTimeout(function () {
        tips.detach().data("timer", 0);
    }, timeout));
}

function checkUA() {
    if(window.lib.env.os.name == 'iPhone' || window.lib.env.os.name == 'iPad' || window.lib.env.os.name == 'Android'){
    return 0;
    }
    var userAgent = window.navigator.userAgent;
    userAgent.match(/iPhone|iPad|iPod/) ? window.lib.env.os.name = 'iPhone' : 'unknown';
    userAgent.match(/Android/) ? window.lib.env.os.name = 'Android' : 'unknown';
}