const express = require('express');
const http = require('http');
const path = require('path');
const config = require('config');
const nunjucks = require('nunjucks');

// middlewares
const bodyParser = require('body-parser');
const cookieParser = require('cookie-parser');

const timeInterval = config.get('timeInterval');

const scheduleproc = require('./lib/scheduleproc');

var app = express();

var index = require('./routers/index');
var data = require('./routers/data');
var flow = require('./lib/flow');

nunjucks.configure(path.join(__dirname, 'views'), { // 设置模板文件的目录，为views
    autoescape: true,
    express: app
});

app.set('view engine', 'html');


//X-Frame-Options: Allow-From http://www.growingio.com
app.use('*', function (req, res, next) {
    res.setHeader('X-Frame-Options', 'ALLOW-FROM https://tt.51gjj.com');
    next();
})


// 给app配置bodyParser中间件
// 通过如下配置再路由种处理request时，可以直接获得post请求的body部分
app.use(bodyParser.urlencoded({extended: true}));
app.use(bodyParser.json({limit: '1000kb'}));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));


// 注册路由
app.use('/zmop', index);
app.use('/zmop/data', data);


const httpPort = config.get('httpPort')

var Server = http.createServer(app);
Server.listen(httpPort, function () {
    flow.sendWarnMsg('17774010868,18805819680', 'zmop restart' + new Date());
    console.log((new Date()) + ' server start http server and listen on: ' + JSON.stringify(Server.address()));
});


// 定时清理日志任务
scheduleproc.BeginCleanLogWork(timeInterval);
