# **1** 温馨提示

!>常见问题

.Q: 为什么老是报token已失效？
 A：token是全局的，2个小时会自动失效。新的token生成老的会立即失效。
    token的管理： 建议贵方最好单独起个线程去管理，每隔一小时50分钟来取一次token，然后存到数据库或者缓存里，每次有用到直接去数据库或缓存里取

!>欢迎你成为旭咪数据服务的合作方，在开始接口调用之前请先确保完成以下事项：
>1. 完成 `合作方入驻` 流程，并已经完成本产品`签约`；
2. 你需要获取一个 `appKey` 和 `appSecret`；


# **2** 开始接入

- 需要签名，签名参数为params里面的参数，签名算法见`附录`

## **2.1** 获取访问令牌token

>**请求URL：** 
- ` zmop/getToken `
  
------------

>**请求方式：**


>- Method: POST
- Content-Type: application/json
- Charset: UTF-8

------------


> **参数：** 
>
|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|sign |是  |String |签名   |
|appKey |是  |String |公钥   |
|timestamp |是  |String | 时间戳 （单位：ms）   |

------------

 >**请求示例**


``` json

{
	"sign":"SDSKKL5KJJKLL6JK1L",
	"params":{
		"appKey":"3FD179425381644F95424B66BE06E3E4",
		"timestamp":"1494828184314"
	}
}
```


 >**返回示例1**

``` json
{
  "code": 0,
  "data": {
    "token": "cd4283827366490eb037bf1b4b28dadc"
  }
}
```

 >**返回示例2**

``` json
{
  "code": -1,
  "msg": "参数错误"
}
```

 >**返回参数说明** 

>|参数名|类型|说明|
|:-----  |:-----|-----                           |
|token |String   |访问令牌(Token的有效期为2小时，当Token未失效时调用该接口，则返回新的Token，有效期重新计算，老的Token同时失效) |
|code |String   |状态码 |
|msg |String   |错误信息 |


------------

## **2.2** 获取芝麻分(普惠版)数据



**请求URL：**
- `zmop/data/score/brief `

**请求方式：**
- Method: POST
- Content-type: application/json
- Charset: UTF-8

**参数：**

|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|appKey |是  |string |公钥   |
|timestamp |是  |string | 时间戳 （单位：ms）   |
|sign     |是  |string | 签名    |
|token     |是  |string | 访问令牌    |
|order_id     |是  |string | 订单号, 传入一个uuid |
|cert_no |是  |string | 用户身份证    |
|cert_name |是  |string | 用户姓名    |
|admit_score |是  |string | 准入分, 目前有`750`,`700`,`650`,`600`,`550`,`500` 5档|


 **请求示例1**
 ``` json
  {
  "sign": "70504237A8AE3C5D8CD76BE5BC374937",
  "params": {
    "appKey": "88A03809137291F333BF2689AB85850E",
    "cert_name": "黄**",
    "cert_no": "330***********",
    "timestamp": 1529977931111,
    "token": "cecd99367d0c4fcba2e15857531dc0ec",
    "order_id": "****"
  },
  "admit_score": "650"
}
```


 **返回示例1**

``` json
  {
    "code": "0",
    "data": {
		//此处参考附录
		...

	}
  }
```
 **返回示例2**

``` json
  {
    "code": -1,
    "msg": "无此订单数据"
  }
```

 **返回参数说明**

|参数名|类型|说明|
|:-----  |:-----|-----                           |
|data |String   |数据结构参照3.2 |
|code |String   |状态码  |
|msg |String   |错误信息  |


 >**备注**

 >  状态码对应的错误信息
- 0   -> 成功
- -1  -> 系统异常
- -1  -> 参数错误
- -1  -> 时间戳超时
- -1  -> 无效的appKey
- -1  -> 签名错误
- -1  -> 您未开通权限
- -1  -> 无此订单号
- -1  -> 鉴权失败
- -1  -> token已失效

## **2.3** 获取行业关注名单(普惠版)数据


**请求URL：**
- `zmop/data/watch_list/brief `

**请求方式：**
- Method: POST
- Content-type: application/json
- Charset: UTF-8

**参数：**

|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|appKey |是  |string |公钥   |
|timestamp |是  |string | 时间戳 （单位：ms）   |
|sign     |是  |string | 签名    |
|token     |是  |string | 访问令牌    |
|order_id     |是  |string | 订单号, 传入一个uuid   |
|cert_no |是  |string | 用户身份证    |
|cert_name |是  |string | 用户姓名    |


 **请求示例1**
 ``` json
  {
    "sign":"89D89A1D07E875C649D6A2D03F8E650A",
    "params":{
        "appKey": "88A03809137291F333BF2689AB85850E",
        "timestamp":"3412xxxxxx01234567",
        "token":"xx",
        "cert_no":"xx",
        "cert_name":"xx",
        "order_id":"20180408121212555qwe23qwe1232sde"
    }
  }
```

 **返回示例1**

``` json
  {
    "code": "0",
    "data": {
		//此处参考附录
		...

	}
  }
```
 **返回示例2**

``` json
  {
    "code": -1,
    "msg": "无此订单数据"
  }
```

 **返回参数说明**

|参数名|类型|说明|
|:-----  |:-----|-----                           |
|data |String   |数据结构参照3.3 |
|code |String   |状态码  |
|msg |String   |错误信息  |


 >**备注**

 >  状态码对应的错误信息
- 0   -> 成功
- -1  -> 系统异常
- -1  -> 参数错误
- -1  -> 时间戳超时
- -1  -> 无效的appKey
- -1  -> 签名错误
- -1  -> 您未开通权限
- -1  -> 无此订单号
- -1  -> 鉴权失败
- -1  -> token已失效


# **3** 附录

## **3.1** 签名算法

签名生成的通用步骤如下：

第一步，设所有发送或者接收到的数据为集合M，将集合M内非空参数值的参数按照参数名ASCII码从小到大排序（字典序），使用URL键值对的格式（即key1=value1&key2=value2…）拼接成字符串stringA。

特别注意以下重要规则：

- 参数名ASCII码从小到大排序（字典序）；
- 如果参数的值为空不参与签名；
- 参数名区分大小写；

第二步，在stringA最后拼接上appSecret得到stringSignTemp字符串，并对stringSignTemp进行MD5运算，再将得到的字符串所有字符转换为大写，得到sign值signValue。

举例：
假设传送的参数如下：
``` json
appKey : 88A03809137291F333BF2689AB85850E,
timestamp : 1494649888152
```


第一步：对参数按照key=value的格式，并按照参数名ASCII字典序排序如下：
``` javascript
stringA="appKey=092217B6B52ED02D46EFFFA7CFA20940&timestamp=1494669826683";
```
第二步：拼接API密钥：
``` javascript
stringSignTemp=stringA+"&appSecret=192006250b4c09247ec02edce69f6a2d"
sign=MD5(stringSignTemp).toUpperCase()="9A0A8659F005D6984697E2CA0A9CF3B7"
```


## **3.2** 芝麻分(普惠版)数据结构


**数据字典**

|参数名|类型|说明|
|:-----  |:-----|-----                           |
|create_time |String   |从芝麻信用获取芝麻分的时间  |
|order_id |String   | 订单号 uuid  |
|is_admittance |String   |准入判断结果 `Y`(用户的芝麻分大于等于准入分数)，`N`（用户的芝麻分小于准入分数），`N/A`（无法评估，例如用户未开通芝麻信用,或芝麻采集的信息不足以评估该用户的信用） |
|admit_score |String   |准入分, 固定值`750`,`700`,`650`,`600`,`550`,`500`,(由于芝麻信用对频繁改动准入分有限制, 故我方只接受这几个分数作为有效参数)|


### 数据样例

```json
{
    "admit_score": "650",
    "is_admittance": "Y",
    "create_time": "2018-04-28 11:26:02",
    "order_id": "iwue-sdlk*****"
  }
```


## **3.3** 行业关注名单(普惠版)数据结构


**数据字典**

|参数名|类型|说明|
|:-----  |:-----|-----                           |
|order_id |String   |订单号 |
|create_time |String   |从芝麻信用获取芝麻分的时间  |
|level |String   |	输入用户返回结果：; `0` 未命中逾期名单; `1` 命中一类名单，例如用户有一周以内的轻微逾期; `2` 命中二类名单，例如用户有一周以上中等逾期; `3` 命中三类名单，例如用户有一个月以上的严重逾期; `N/A` 无法评估该用户逾期状况，例如未获得用户授权。  |


### 数据样例

```json
{
    "level": "0",
    "create_time": "2018-04-28 11:26:02",
    "order_id": "2018042710535*****QcPMRFLn8b7qYb"
  }
```
