/**
 * Created by xaj on 2017/5/26.
 */
var rp      = require('request-promise');
var request = require('request');
var config = require('config')

var tj1   = config.get('tj1');
var tj2 = config.get('tj2');


/*************************************************************************************
 * Description: getToken
 *      Author: xaj
 *        Date: 2017/6/05
 *   Parameter: body       Obeject    传进来的参数
 *    Callback: promise
 *      Return: N/A
 *     Caution:
 *************************************************************************************/
function getToken(body) {
    return new Promise((resolve, reject) => {
        let form_data = body
        let reqUrl = tj2 + "access/getToken";
        let options= {
            url: reqUrl,
            method: "POST",
            json: true,
            body: form_data,
            headers: {
                'content-type': 'application/json'
            }
        }
        request(options,(e,r,b)=>{
            if(e){
                console.error('[getToken] error: ' + JSON.stringify(e));
                reject(e);
            }else{
                console.log('[getToken] success result: ' + JSON.stringify(b));
                resolve(b);
            }
        })
    })
}

/*************************************************************************************
 * Description: getOrderSn
 *      Author: xaj
 *        Date: 2017/6/05
 *   Parameter: body      Object	传进来的参数
 *    Callback: promise
 *      Return: N/A
 *     Caution:
 *************************************************************************************/
function getOrderSn(body) {
    return new Promise((resolve, reject) => {
        let form_data = body;
        let reqUrl = tj2 + "order/getOrderSn";
        let options= {
            url: reqUrl,
            method: "POST",
            json: true,
            body: form_data,
            headers: {
                'content-type': 'application/json'
            }
        }
        request(options,(e,r,b)=>{
            if(e){
                console.error('[getOrderSn] error: ' + JSON.stringify(e));
                reject(e);
            }else{
                console.log('[getOrderSn] success result: ' + JSON.stringify(b));
                resolve(b);
            }
        })
    })
}

/*************************************************************************************
 * Description: 检查签名是否失效
 *      Author: xaj
 *        Date: 2017/5/27
 *   Parameter: body,      Object 传进来的参数
 *    Callback: promise
 *      Return: N/A
 *     Caution:
 *************************************************************************************/
function signValidityCheck(body) {
    return new Promise((resolve, reject) => {
        let form_data = body;
        let url = tj2 + "access/signValidityCheck";
        let options= {
            url: url,
            method: "POST",
            json: true,
            body: form_data,
            headers: {
                'content-type': 'application/json'
            }
        }
        request(options,(e,r,vb)=>{
            if(e) {
                console.error('[signValidityCheck] signValidityCheck error: ' + JSON.stringify(e));
                reject("服务器维护")
            }
            else {
                console.log('[signValidityCheck] signValidityCheck success: ' + JSON.stringify(vb));
                resolve(vb);
            }
        })
    })

}

async function app_key_info(app_key) {
    try {
        let resp = await rp.get({
            url: tj2 + 'customer/query/?appKey=' + app_key,
            json: true
        })
        if (resp.code == 0) {
            if (resp.data.customerList.length > 0) {
                return resp.data.customerList[0]
            } else {
                throw new Error('无效的appKey')
            }
        } else {
            throw new Error('API-[app_key_info] error ', resp)
        }
    } catch (e) {
        throw e
    }
}

// app_key_info('122818D0E79CCEB3B8D3D6BB51BF615E').then(r=>{console.log(r)}).catch(e=>{console.log(e)})

exports.getToken = getToken;
exports.app_key_info = app_key_info;
exports.getOrderSn = getOrderSn;
exports.signValidityCheck = signValidityCheck;
