const rp = require('request-promise'),
    moment = require('moment'),
    fs = require('fs'),
    rsa = require('./rsa'),
    orm = require('../orm'),
    extend = require('extend'),
    log = console.log.bind(console),
    error = console.error.bind(console)


function build_transaction_id() {
    let t = moment().format('YYYYMMDDHHmmssSSS')
    let str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890'
    while (t.length < 32) {
        t += str[Math.round(Math.random() * (str.length - 1))]
    }
    return t
}


//  芝麻分
async function score(app_id, auth_token, user_id) {
    let transaction_id = build_transaction_id()
    let data = {
        app_id: app_id,
        method: 'zhima.credit.score.get',
        format: 'JSON',
        charset: 'utf-8',
        sign_type: 'RSA2',
        timestamp: moment().format('YYYY-MM-DD HH:mm:ss'),
        version: '1.0',
        auth_token: auth_token,
        biz_content: JSON.stringify({transaction_id: transaction_id, product_code: 'w1010100100000000001'}),
    }
    data.sign = rsa.sign(data, app_id)
    let resp = await rp.post({
        url: 'https://openapi.alipay.com/gateway.do',
        json: true,
        form: data
    })
    let row = {
        transaction_id: transaction_id,
        resp: JSON.stringify(resp),
        open_id: user_id,
        platform: 'alipay',
        method: 'watch_list'
    }
    log('zmop_score resp: ', resp)
    await orm.create_api_task(row)
    if (rsa.verify(resp.sign, JSON.stringify(resp.zhima_credit_score_get_response), app_id)) {
        return resp.zhima_credit_score_get_response
    } else {
        error('API-[ alipay/score ] 验签失败| app_id: ', app_id)
        throw new Error('验签失败')
    }
}

//  行业关注名单
async function watch_list(app_id, auth_token, user_id) {
    let transaction_id = build_transaction_id()
    let data = {
        app_id: app_id,
        method: 'zhima.credit.watchlistii.get',
        format: 'JSON',
        charset: 'utf-8',
        sign_type: 'RSA2',
        timestamp: moment().format('YYYY-MM-DD HH:mm:ss'),
        version: '1.0',
        auth_token: auth_token,
        biz_content: JSON.stringify({transaction_id: transaction_id, product_code: 'w1010100100000000022'}),
    }
    data.sign = rsa.sign(data, app_id)
    let resp = await rp.post({
        url: 'https://openapi.alipay.com/gateway.do',
        json: true,
        form: data
    })
    let row = {
        transaction_id: transaction_id,
        resp: JSON.stringify(resp),
        open_id: user_id,
        platform: 'alipay',
        method: 'watch_list'
    }
    log('zmop_score resp: ', resp)
    await orm.create_api_task(row)
    if (rsa.verify(resp.sign, JSON.stringify(resp.zhima_credit_watchlistii_get_response), app_id)) {
        return resp.zhima_credit_watchlistii_get_response
    } else {
        error('API-[ alipay/score ] 验签失败| app_id: ', app_id)
        throw new Error('验签失败')
    }
}

async function access_token(app_id, auth_code,) {
    let data = {
        app_id: app_id,
        method: 'alipay.system.oauth.token',
        charset: 'utf-8',
        sign_type: 'RSA2',
        timestamp: moment().format('YYYY-MM-DD HH:mm:ss'),
        version: '1.0',
        grant_type: 'authorization_code',
        code: auth_code
    }
    data.sign = rsa.sign(data, app_id)
    let resp = await rp.post({
        url: 'https://openapi.alipay.com/gateway.do',
        json: true,
        form: data
    })
    console.log('##### Access_token #####\n', resp)
    if (resp.error_response) {
        return resp.error_response
    }
    if (rsa.verify(resp.sign, JSON.stringify(resp.alipay_system_oauth_token_response), app_id)) {
        console.log('access_token: ', resp)
        return resp.alipay_system_oauth_token_response
    } else {
        error('API-[ alipay/access_token ] 验签失败| app_id: ', app_id)
        throw new Error('验签失败')
    }
}


//  支付用户账户
async function pay_forName(open_id,parter_name,appKey,cert_name) {
    let transaction_id = build_transaction_id()
    let data = {
        app_id: '2018030502317524',
        method: 'alipay.fund.trans.toaccount.transfer',
        format: 'JSON',
        charset: 'utf-8',
        sign_type: 'RSA2',
        timestamp: moment().format('YYYY-MM-DD HH:mm:ss'),
        version: '1.0',
        biz_content: JSON.stringify({
            out_biz_no: transaction_id,
            payee_type: 'ALIPAY_USERID',
            payee_account: open_id,
            amount: '0.1',
            payer_show_name: parter_name,
            payee_real_name: cert_name
        }),
    }
    await orm.insert_pay_task(transaction_id,appKey,open_id,cert_name);
    data.sign = rsa.signpay(data, "2018030502317524")
    let p = formatUrl(data)
    let resp = await rp.post({
        url: p.url,
        form: p.execParams,
        json: true
    })
    let row = {
        transaction_id: transaction_id,
        resp: JSON.stringify(resp),
        open_id: open_id,
        platform: 'alipay',
        method: 'pay'
    }
    log('pay_forName resp: ', resp)
    await orm.create_api_task(row)
    return resp.alipay_fund_trans_toaccount_transfer_response;
}


module.exports = {
    build_transaction_id,
    access_token,
    score,
    pay_forName
}

function formatUrl(params) {
    let requestUrl = 'https://openapi.alipay.com/gateway.do';
    // 需要放在 url 中的参数列表
    const urlArgs = [
        'app_id', 'method', 'format', 'charset',
        'sign_type', 'sign', 'timestamp', 'version',
        'notify_url', 'return_url', 'auth_token', 'app_auth_token',
    ];
    for (const key in params) {
        if (urlArgs.includes(key)) {
            const val = encodeURIComponent(params[key]);
            requestUrl = `${requestUrl}${requestUrl.includes('?') ? '&' : '?'}${key}=${val}`;
            // 删除 postData 中对应的数据
            delete params[key];
        }
    }
    return {execParams: params, url: requestUrl};
}

// access_token('2018042460057138','e58ed29be5664ef9b174f9b02776UX48').then(r=>{log(r)}).catch(e=>{log(e)})