var express = require('express'),
    router = express.Router(),
    orm = require('../lib/orm'),
    flow = require('../lib/flow'),
    utils = require('../lib/utils'),
    oss = require('../lib/oss-node'),
    Alipay = require('../lib/alipay/alipay'),
    moment = require('moment'),
    config = require('config'),
    log = console.log.bind(console),
    warn = console.warn.bind(console),
    error = console.error.bind(console),
    URL = require("url")

const entities = config.get('entities')

router.use('*', function (req, res, next) {
    let keys = Object.keys(req.query)
    if (keys.length > 0) {
        log('####### REQUEST ######\n [', req.baseUrl, ' ] query: ', req.query)
    }
    keys = Object.keys(req.body)
    if (keys.length > 0) {
        log('####### REQUEST ######\n [', req.baseUrl, ' ] body: ', req.body)
    }
    next()
})


let Room = new Map()
router.ws('/ws', function (ws, req) {
    log('ws connected: ', JSON.stringify(req.query));
    Room.set(req.query.order_id, ws)
    ws.on('message', function (msg) {
        //  心跳
        ws.send(msg.replace(/heart/, 'alive'))
    });
    ws.on('close', function () {
        Room.delete(req.query.order_id)
        log('ws close: ', req.query.order_id)
        log('ws total: ', Room.size)
    })
});

router.post('/auth', async (req, res) => {
    try {
        let body = req.body
        if (!body.redirect) {
            throw new Error('参数错误')
        }
        if (!body.app_id) {
            return res.sendStatus(400).end()
        }
        await utils.test_order_id(body.order_id)
        await orm.check_app_key(body.appKey)
        let app_id = body.app_id
        let row = {
            app_id: app_id,
            platform: 'alipay',
            app_key: body.appKey,
            order_id: body.order_id,
            cert_no: body.cert_no,
            cert_name: body.cert_name,
            cert_phone: body.cert_phone,
            redirect: body.redirect,
        }
        //  上传到oss
        let ret = await orm.company_info(body.appKey)
        log(ret)
        let oss_data = protocol(body.app_id, ret[0].company, ret[0].name, ret[0].partya)
        let oss_key = `protocol/${moment().format('YYYY-MM-DD')}/${body.order_id}`
        await oss.upload(oss_key, oss_data)
        delete body.cert_no
        delete body.cert_name
        delete body.cert_phone
        delete body.app_id
        delete body.system
        let redirect_uri = encodeURIComponent(`${config.get('host').replace('http', 'https')}/zmop/result`)
        let state = utils.to_base64(JSON.stringify(body))
        let auth_url = `https://openauth.alipay.com/oauth2/publicAppAuthorize.htm?app_id=${app_id}&scope=auth_zhima&redirect_uri=${redirect_uri}&state=${encodeURIComponent(state)}`
        let qrcode = encodeURIComponent(auth_url)
        let scheme = `alipayqr://platformapi/startapp?saId=10000007&qrcode=${qrcode}`
        await orm.create_task(row)
        log('scheme: ', scheme)
        res.json({code: 0, auth_url: scheme, channel: 'APP'})
    } catch (e) {
        warn(`[${req.originalUrl}-warn]: `, e)
        if (e.message == '无效的appKey') {
            return res.json({code: -1, msg: '无效的appKey'})
        }
        if (/[a-zA-Z]+/.test(e.message)) {
            return res.json({code: -1, msg: '系统错误, 请稍后再试'})
        }
        return res.json({code: -1, msg: e.message})
    }
})


//  http://localhost:10031/zmop/result?state=eyJvcmRlcl9pZCI6IjIwMTgwNTA0MTEzMDA3NTcxb1gxSUpjaHBkb1RxcWxVIiwiZXh0cmFzIjoie1widXNlcl9pZFwiOjMyMTQ1NjV9In0=&app_id=2018042460057138&source=alipay_wallet&userOutputs=auth_zhima&scope=&alipay_token=&error_scope=auth_zhima,ZMCSP.ALIPAY_NOT_PRIVATE_ACCOUNT&auth_code=e909c5e8616a48acab4030448da1OX64
router.get('/result', async (req, res) => {
    try {
        let result = {
            success: 'true',
            error_msg: '操作成功'
        }
        if (req.query.order_id) {
            if (req.query.status == 'success') {
                result.success = 'true'
            } else {
                result.success = 'fail'
                result.error_msg = req.query.msg
            }
            return res.render('result.html', result)
        }
        if (!req.query.app_id || !req.query.state) {
            return res.render('error.html', {error_message: '参数错误'})
        }
        let query = req.query
        if (query.scope != 'auth_zhima') {
            result.success = 'false'
            result.error_msg = query.error_scope
            if (query.error_scope.indexOf('ZMCSP.ALIPAY_NOT_REAL_NAME_CERTIFY')!= -1){
                result.error_msg = '支付宝账号未完成实名认证'
            }
        }
        let state = JSON.parse(utils.from_base64(query.state.replace(/ /g,'+')))
        log('state: ', state)
        let resp = await Alipay.access_token(query.app_id, query.auth_code)
        log('resp: ', resp)
        if (resp.code && resp.code != '10000') {
            result.success = 'false'
            result.error_msg = resp.msg
            if (resp.sub_code == 'isv.code-invalid') {
                result.error_msg = '无效的授权码'
            }
        }
        //检测姓名是否匹配
        if (result.success == 'true') {
            let check = await flow.checkName(state.appKey, resp.user_id, state.order_id);
            if (check.code !== 0) {
                result.success = 'fail';
                result.error_msg = '支付宝账号和姓名不匹配，请确认姓名是否正确';
            }else{
                let task = {
                    open_id: resp.user_id,
                    platform: 'alipay',
                    app_id: query.app_id,
                    access_token: resp.access_token
                }
                let data = await flow.save_score(task)
                log('\n#### Save zm_score #### \n order_id: ', state.order_id, ' \n app_key: ', data)
            }
        }

        await flow.notify_result(state, result.success, result.error_msg)
        let row = {
            success: result.success,
            error_msg: result.error_msg,
            access_token: resp.access_token,
            open_id: resp.user_id,
        }
        await orm.update_task(row, state.order_id)
        await orm.insert_openId(resp.user_id,resp.access_token,query.app_id,'alipay');
        if (Room.has(state.order_id)) {
            log('Webscoket send: ', state.order_id, JSON.stringify(result))
            Room.get(state.order_id).send(JSON.stringify(result))
        }
        res.render('result.html', result)
    } catch (e) {
        error(`[/zmop/result-error]: `, e)
        if (e.message == '无效的授权码') {
            return res.render('result.html', {error_msg: '无效的授权码'})
        }
        return res.render('result.html', {error_msg: '系统错误, 请稍后再试'})
    }
})

function protocol(app_id, company, name, us) {
    log('######## PROTOCOL ########: ', app_id, company, name, us)
    if (!us) {
        us = '杭州惠风网络科技有限公司'
    }
    if (app_id == '2018051160085345' && us == '杭州惠风网络科技有限公司') {
        us = ''
    }
    return `用户授权服务协议
  【重要提示】：
   为了保障您的合法权益，请您务必审慎阅读、充分理解本授权书之条款、承诺，特别是涉及被授权方（包括但不限于${us}、 ${entities[app_id]}及相关合作方、关联方等，下同）责任的条款，或限制您权利的条款，或加粗条款
        除非您已阅读、接受并自愿遵守本授权书所有的条款，否则您无权使用被授权方提供的查询服务。您的申请、使用或登录等行为，亦或点击、勾选“确认”、“同意”、“申请”或“查询”按钮，亦或填写资料申请服务等，即表明您对本授权书含义及法律后果的知悉和全面理解，并自愿签署并遵照执行。
   【致被授权方】：
        （本人拟向__${company}___（下简称“${name}”）申请其提供的服务（包括但不限于融资服务、借贷咨询、借贷方案推荐、助贷服务、分期服务、委托服务、代办服务等，下同），需查询本人的芝麻信用数据。现本人不可撤销的授权：1）授权被授权方收集、存储、使用本人提交或本人授权${name}提交的姓名、身份证号码、手机号码等个人资料；2）授权被授权方根据芝麻信用管理有限公司（下简称“芝麻信用公司”）的规则向芝麻信用公司发起登录、收集、查询等服务请求，代为查询、收集、存储芝麻信用公司反馈的本人芝麻信用数据，并授权被授权方传输给${name}用于存储、分析使用、评估本人情况；必要时授权${name}可同时向本人所申请服务之实际提供方反馈本人之个人信息及评估结果。本人知悉，本授权书包含了被授权方收集、使用、查询、存储和传输本人芝麻信用数据的条款，并接受被授权方及${name}的规则/评估体系/评估方法。
        就上述授权，本人同时确认并承诺如下：
        1. 本人知悉，向被授权方/${name}提供的本人之个人信息（包括但不限于姓名、手机号码、身份证号码、芝麻信用数据等，下同）属于本人重要的个人信息，本人同意并不可撤销地授权被授权方在保证本人信息安全的前提下，存储、使用本人之个人信息，并仅向本人授权的相关方提供，因被授权方提供该等服务所得收益归被授权方所有。除前述情况及因国家机关、生效判决等强制性要求而必须提供外，被授权方不应将本人之个人信息提供给任何未经本人授权的其他机构或平台。
        2. 本人知悉，被授权方会采用行业通行安全技术标准保护本人之个人信息，以防止个人信息及数据丢失、被盗用或遭窜改，除非遇到不可抗力（包括但不限于黑客攻击、系统故障、软硬件故障、自然灾害、政策变动等）的影响。
        3. 本授权委托书系本人做出的单方承诺，效力具有独立性，不因其他合同的任何条款无效而失效。
        4. 以上授权期限为本人作出本授权承诺之日起至本授权委托书约定事项完成之日止。
        5. 若本人与被授权方发生任何纠纷或争议，首先应友好协商解决；协商不成的，本人同意将纠纷或争议提交杭州仲裁委员会仲裁解决。本授权书的成立、生效、履行、解释及纠纷解决，适用中华人民共和国大陆地区法律（不包括冲突法）。
        6. 本人已知悉本授权书所有内容（特别是加粗字体内容）的意义以及由此产生的法律后果，自愿作出上述授权，本授权书是本人真实的意思表示，本人同意承担由此带来的一切法律后果。
        7. 本授权书自填写个人资料，或点击、勾选“确认”、“同意”、“申请”或“查询”等按钮之日起生效。
        特此授权。
`
}


module.exports = router;