'use strict';
const Service = require('egg').Service;
class InvestmentService extends Service {

    async getList(input_params) {
        const { ctx } = this;
        const condition = {
            page: input_params.page,
            where: {
                type_id: input_params.type_id,
                language: input_params.language,
                status: 1,
                is_deleted: 0,
            },
            order: [['id', 'desc']]
        };
        const ret = await ctx.blockModel.OfficialInvestment.list(condition);
        return ret;
    }

    async getTypeList() {
        const { ctx } = this;
        const ret = await ctx.blockModel.OfficialInvestmentType.all({ where: { status: 1, is_deleted: 0 }, order: [['sort_order', 'ASC']] });
        return ret;
    }
}

module.exports = InvestmentService;