
'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;

    const CreditCallriskReport = app.prometheusModel.define('credit_callrisk_report', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        report_no: {
            type: STRING,
            allowNull: false,
        },
        user_id: {
            type: STRING,
            allowNull: false,
        },
        app_type_id: {
            type: STRING,
            allowNull: false,
        },
        app_user_id: {
            type: STRING,
            allowNull: false,
        },
        app_id: {
            type: STRING,
            allowNull: false,
        },
        mobile: {
            type: STRING,
            allowNull: false,
        },
        operator: {
            type: STRING,
            allowNull: false,
        },
        net_time: {
            type: STRING,
            allowNull: false,
        },
        call_result_assessment: {
            type: STRING,
            allowNull: false,
        },
        // status: {
        //     type: ENUM('offline', 'online'),
        //     allowNull: false,
        // },
        // is_deleted: {
        //     type: INTEGER,
        //     allowNull: false,
        // },
        // updated_at: {
        //     type: DATE,
        //     allowNull: true,
        //     get() {
        //         const date = this.getDataValue('updated_at');
        //         return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
        //     },
        // },
        created_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'credit_callrisk_report',
        });

    CreditCallriskReport.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await CreditCallriskReport.findOne({
            attributes: attributes,
            where: where,
        });
    }

    CreditCallriskReport.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await CreditCallriskReport.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    CreditCallriskReport.list = async (data = {}) => {
        const limit = data.limit ? Number(data.limit) : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await CreditCallriskReport.findAndCountAll(condition);
        return { page, count, rows };
    }

    CreditCallriskReport.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await CreditCallriskReport.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    CreditCallriskReport.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        try {
            const res = await CreditCallriskReport.update(params, { where: where })
            return res;
        } catch (error) {
            throw (error);
        }
    }

    return CreditCallriskReport;

};