'use strict';

const Controller = require('egg').Controller;
const moment = require('moment');
class InvestmentController extends Controller {


    //投资者关系列表
    async list() {
        const { ctx, service } = this;
        const input_params = ctx.params;
        const rule = {
            page: { type: 'string', required: true }, //类型
            type_id: { type: 'string', required: true }, //类型
            language: { type: 'string', required: true }, //语言
        }
        ctx.validate(rule, input_params);
        const ret = await service.official.investment.getList(input_params);
        let rows = [];
        ret.rows.forEach(ele => {
            let file_url = '';
            if (ele.file_url) {
                file_url = this.app.config.CDN_BASE_URL + ele.file_url;
            }
            let item = { title: ele.title, file_url: file_url, type_id: ele.type_id, language: ele.language, created_time: moment(ele.created_time).format('YYYY-MM-DD') };
            rows.push(item);
        })
        ctx.success({ page: ret.page, count: ret.count, rows: rows });
    }

    //投资者关系项列表
    async typeList() {
        const { ctx, service } = this;
        const investment_types = await service.official.investment.getTypeList();
        let ret = [];
        investment_types.forEach(ele => {
            ret.push({ id: ele.id, name: ele.name });
        })
        ctx.success(ret);
    }


}

module.exports = InvestmentController;
