'use strict';
const Service = require('egg').Service;

class MineService extends Service {
  // 我的贷款
  async getMyLoans() {
    const { ctx } = this;

    // 调用php接口
    const phpResult = await ctx.helper.send_request(this.config.PHP_URL + '/business/loanschedule/v3/loans/get_list', {}, { method: 'POST', headers: { Cookie: ctx.oldCookie }, dataType: 'json' });
    let phpData;
    if (phpResult.status === 200) {
      phpData = phpResult.data.ret;
    }

    // todo
    const ret = { results: phpData };
    return ret;
  }

  // 我的信用卡
  async getMyCreditCards() {
    const { ctx } = this;

    // 调用php接口
    const phpResult = await ctx.helper.send_request(this.config.PHP_URL + '/business/loanschedule/v3/creditcards/get_list', {}, { method: 'POST', headers: { Cookie: ctx.oldCookie }, dataType: 'json' });
    let phpData;
    if (phpResult.status === 200) {
      phpData = phpResult.data.ret;
    }

    // todo
    const ret = { results: phpData };
    return ret;
  }
}

module.exports = MineService;
