'use strict';

module.exports = app => {
    const router = app.router.namespace(app.config.projectRootPath + '/cd');
    const loginAuth = app.middleware.loginAuth({ type: 'new' });//登录中间件

    //贷款计算器
    router.post('third', '/caculator', 'cd.loanCaculator.caculator');

    //资讯-详细内容
    router.get('third', '/news/:id', 'cd.news.getNews');
    //资讯-列表
    router.post('third', '/news/list', 'cd.news.getNewsList');

    //预售楼盘-搜索历史
    router.get('/presell/search_history', 'cd.presellSearchHistory.getSearchHistory');
    //预售楼盘-清除搜索历史
    router.put('/presell/search_history', 'cd.presellSearchHistory.cleanSearchHistory');
    //预售楼盘-列表
    router.post('third', '/presell/house/list', 'cd.presellHouse.getPresellHouseList');
    //预售楼盘-详情
    router.get('third', '/presell/house/:id', 'cd.presellHouse.getPresellHouse');

    //摇号-楼盘名字模糊匹配
    router.post('third', '/lottery/name', 'cd.lotteryPublicise.getHouseName');
    //摇号-用户查询
    router.post('/lottery/publicise', loginAuth, 'cd.lotteryPublicise.getLotteryPublicise');
    //摇号-用户查询历史
    router.get('/lottery/query/list', 'cd.lotteryPublicise.getUserQueryList');
    //摇号-用户根据查询历史重新查询
    router.post('/lottery/review', loginAuth, 'cd.lotteryPublicise.updateQuery');

    //用户-授权登录返回用户五要素
    router.post('third', '/user/auth', 'cd.user.userAuth');






};