'use strict';
const Service = require('egg').Service;
const APPID = 'wx4769ebba9b91f8ec';
const SECRET = '680440637b4e38c9b66529cfd5dc590e';

class WechatService extends Service {
  async getAccessToken() {
    const { ctx } = this;
    const url = 'https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=' + APPID + '&secret=' + SECRET;

    // 先从redis中取
    let token = await this.app.memcache.get('wechat_course_accessToken');
    if (ctx.isEmpty(token)) {
      const resp = await ctx.helper.send_request(url, {}, { method: 'GET' });
      if (resp.status === 200 && !ctx.isEmpty(resp.data) && !ctx.isEmpty(resp.data.access_token)) {
        token = resp.data.access_token;
        await this.app.memcache.set('wechat_course_accessToken', token, resp.data.expires_in);
      }
    }

    return token;
  }

  async callbackAction() {
    const { ctx } = this;
    ctx.logger.info('course_wechat_receive: ' + JSON.stringify(ctx.request.body));
    await this.sendMsg(ctx.request.body);
  }

  async sendMsg(data) {
    const { ctx } = this;

    if (ctx.isEmpty(data)) {
        return;
    }

    //只有MsgType为miniprogrampage才发送
    if (ctx.isEmpty(data.MsgType) || ctx.isEmpty(data.Title) || data.MsgType !== 'miniprogrampage' || data.Title !== '趣选课') {
        return;
    }

    const token = await this.getAccessToken();
    const url = 'https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=' + token;
    const params = {
      access_token: token,
      touser: data.FromUserName,
      msgtype: 'text',
      text: { content: 'hello world' },
    };
    const resp = await ctx.helper.send_request(url, params, { method: 'POST' });
    ctx.logger.info('course_wechat_resp: ' + JSON.stringify(resp));
    return;
  }
}

module.exports = WechatService;
