
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class AbroadHouseService extends Service {

    /**
     * 海外房列表
     */
    async abroadHouseList(condition) {
        const { ctx } = this;
        let page = Number(condition.page) || 1;
        let pageSize = Number(condition.page_size) || 10;
        let filter = {
            page: page,
            limit: pageSize,
            where: {
                valid: 1,
                status: 'online',
            },
            order: [['order', 'asc']]
        }
        if (condition.name) {//关键词搜索 模糊查询
            //增加搜索历史
            let addHistory = {
                type: 4,
                key_word: condition.name
            };
            await ctx.service.house.v2.searchHistory.addSearchHistory(addHistory);
            filter.where.name = { $like: '%' + condition.name + '%' }
        }
        let abroadList = await ctx.realestateModel.AbroadHouse.list(filter);
        let list = abroadList.rows;
        let data = [];
        for (let i in list) {
            data[i] = {
                id: list[i].id,
                name: list[i].name || '',
                images: list[i].images ? JSON.parse(list[i].images) : [],
                tags: list[i].tags ? JSON.parse(list[i].tags) : [],
                total_price: list[i].total_price === '0.00' ? '--' : list[i].total_price,
                url: list[i].url || '',
            }
        }
        let ret = {
            results: data,
            count: abroadList.count
        };
        return ret;
    }


}

module.exports = AbroadHouseService;
