'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, ENUM, DATE } = app.Sequelize;
    const ResidentialDeveloper = app.realestateModel.define('residential_developer', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        residential_id: {
            type: INTEGER,
            allowNull: true
        },
        developer_id: {
            type: INTEGER,
            allowNull: true
        },
        remark: {
            type: STRING,
            allowNull: true
        },
        status: {
            type: ENUM('online', 'offline'),
            allowNull: true
        },
        valid: {
            type: INTEGER,
            allowNull: true
        },
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },

    }, {
            timestamps: false,
            tableName: 'residential_developer',
        });

    ResidentialDeveloper.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await ResidentialDeveloper.findOne({
            attributes: attributes,
            where: where,
        });
    }


    ResidentialDeveloper.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await ResidentialDeveloper.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    ResidentialDeveloper.list = async (data = {}) => {
        const limit = data.limit ? data.limit : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await ResidentialDeveloper.findAndCountAll(condition);
        return { page, count, rows };
    }

    ResidentialDeveloper.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await ResidentialDeveloper.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    ResidentialDeveloper.edit = async (data) => {

        const where = data.where;
        const params = data.params;
        try {
            return res = await ResidentialDeveloper.update(params, { where: where })
        } catch (error) {
            throw (error);
        }
    }

    return ResidentialDeveloper;

};
