'use strict';

const moment = require('moment');

module.exports = app => {
    const { INTEGER, STRING, DATE, DECIMAL } = app.Sequelize;
    const CreditOrderPreferential = app.prometheusModel.define('credit_order_preferential', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        type: INTEGER,
        alias: STRING,
        name: STRING,
        price: DECIMAL,
        description: STRING,
        start_time: {
            type: DATE,
            get() {
                const date = this.getDataValue('start_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        end_time: {
            type: DATE,
            get() {
                const date = this.getDataValue('end_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        valid: INTEGER
    }, {
        timestamps: false,
        tableName: 'credit_order_preferential',
    });

    return CreditOrderPreferential;

};
