
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class CommonService extends Service {

    /**
     * 
     * @param {*} type 黑名单00通话01
     * @param {*} id 报告自增编号(report_id)
     */
    async getReportNo(type, id) {
        let prefix = '51GJJ' + moment().format('YYYYMMDD') + type;
        let suffix = String(Number(id) + 12580);
        if (suffix.length > 5) {
            let subStart = suffix.length - 5;
            suffix = suffix.substring(subStart, suffix.length + 1);
        }
        return prefix + suffix;
    }


    /**
    * 
    * @param {*} type 黑名单00通话01
    * @param {*} id 订单自增编号(order_id)
    */
    async getOrdertNo(type, id) {
        let prefix = '51GJJOD' + moment().format('YYYYMMDD') + type;
        let suffix = String(Number(id) + 12580);
        if (suffix.length > 5) {
            let subStart = suffix.length - 5;
            suffix = suffix.substring(subStart, suffix.length + 1);
        }
        return prefix + suffix;
    }

    /**
     * 签名函数
     * @param {*} params 需要签名的参数
     */
    async sign(params, appSecret) {
        const { ctx } = this;
        let sign = '';
        if (!params) {
            return sign;
        }
        //键名排序
        const sortParamsKey = Object.keys(params).sort();
        //键值拼接-升序
        let sortValues = '';
        for (let i in sortParamsKey) {
            if (sortParamsKey[i] === 'sign') {
                continue;
            }
            sortValues += sortParamsKey[i] + '=' + params[sortParamsKey[i]] + '&';
        }
        sortValues += 'appSecret=' + appSecret;
        sign = await ctx.helper.md5(sortValues).toUpperCase();
        ctx.logger.info({ sign: sign });
        return sign;
    }

    async unifiedOrder(type, order_id) {

        const { ctx } = this;
        const order = await ctx.service.credit.order.getOrderInfo(order_id);
        const price = order.price * 100 - order.preferential_price * 100;
        console.info(price);
        if (price <= 0) {
            ctx.failed('error price');
        }
        if (type === 'wexin') {

            let body = '黑名单报告检测支付';
            if (order.type === 2) {
                body = '个人通话风险检测支付';
            }
            const data = {
                body,
                order_id,
                trade_no: moment().valueOf() + ctx.helper.PrefixInteger(order_id, 11),
                total_fee: price,
                notify_url: '',
                product_id: order.order_no,
                scene_info: { h5_info: { type: 'Wap', wap_url: this.config.PHP_URL, wap_name: '我的信用' }, },
            };

            const ret = await this.WexinUnifiedOrder(data);

            const pay_data = {
                order_id,
                trade_no: data.trade_no,
                description: data.body,
                prepay_id: ret.prepay_id || 0,
                amount: data.total_fee,
                unifiedorder_result: JSON.stringify(ret),
                client_ip: ctx.helper.getClientIP(),
            };
            await this.addCreditPay(pay_data);

            return { url: ret.mweb_url, order_id: order_id, trade_no: data.trade_no };

        } else if (type === 'alipay') {
            //TODO
        }
        return false;
    }

    async WexinUnifiedOrder(params) {

        const { ctx } = this;
        const { body, trade_no, total_fee, notify_url, product_id, scene_info } = params;
        const appid = '';
        const mch_id = '';
        const trade_type = 'MWEB';
        const nonce_str = ctx.helper.createNoncestr();
        const spbill_create_ip = ctx.helper.getClientIP();
        let json_data = {
            appid,
            mch_id,
            body,
            trade_no,
            total_fee,
            spbill_create_ip,
            notify_url,
            product_id,
            scene_info,
            trade_type,
            nonce_str,
        };
        const sign = this.getWexinSign(json_data);
        json_data.sign = sign;
        const xml_data = ctx.helper.jsonToxml(json_data);
        const url = 'https://api.mch.weixin.qq.com/pay/unifiedorder';
        const result_wexin = await ctx.curl(url, { timeout: 3000, method: 'POST', data: xml_data, headers: { 'content-type': 'text/html', }, streaming: false, dataType: 'text', });
        console.info(result_wexin);
        if (result_wexin.status !== 200) {
            ctx.failed('wexin pay failed');
        }
        const result = await ctx.helper.xmlTojson(result_wexin.data);
        ctx.logger.info({ pay_wexin_params: json_data, pay_wexin_result: result });
        let ret = {};
        for (let key in result) {
            ret[key] = result[key][0];
        }
        let error_msg = 'wexin pay error';
        if (!ret.return_code || ret.return_code !== 'SUCCESS') {
            error_msg = ret.return_msg || error_msg;
            // ctx.failed(error_msg);
        }
        if (!ret.result_code || ret.result_code !== 'SUCCESS') {
            error_msg = ret.err_code_des || error_msg;
            // ctx.failed(error_msg);
        }

        return ret;
    }

    async addCreditPay(params) {

        const { ctx } = this;
        const { order_id, trade_no, prepay_id, amount, description, unifiedorder_result, client_ip } = params;
        const data = {
            order_id,
            trade_no,
            prepay_id,
            amount,
            description,
            unifiedorder_result,
            client_ip,
        }
        const ret = await ctx.prometheusModel.CreditPay.add(data);

        return ret;
    }

    async alipay() {

    }

    async WexinCheckPay(params) {

        const { ctx } = this;
        const { transaction_id, trade_no } = params;
        const pay_info = await ctx.prometheusModel.CreditPay.one({ where: { trade_no: out_trade_no } });
        if (!pay_info || pay_info.order_id) {
            ctx.failed('pay info error');
        }
        const order_info = await ctx.service.credit.common.getOrderInfo(pay_info.order_id);
        const nonce_str = ctx.helper.createNoncestr();
        const url = 'https://api.mch.weixin.qq.com/pay/orderquery';
        let data_obj = {

            appid: this.config.MCH_APPID,
            mch_id: this.config.MCH_ID,
            transaction_id,
            out_trade_no: trade_no,
            nonce_str,
        }
        const sign = this.getWexinSign(data_obj);
        data_obj.sign = sign;
        const xml_data = ctx.helper.jsonToxml(data_obj);

        const result_wexin = await ctx.curl(url, { timeout: 3000, method: 'POST', data: xml_data, headers: { 'content-type': 'text/html', }, streaming: false, dataType: 'text', });
        if (result_wexin.status) {
            ctx.failed('wexin orderquery error1');
        }
        const ret = await ctx.helper.xmlTojson(result_wexin.data);
        if (ret.return_code !== 'SUCCESS' && ret.result_code !== 'SUCCESS') {
            ctx.failed('wexin orderquery error2');
        }
        let ret_data = {};
        for (let key in ret) {
            ret_data[key] = ret[key][0];
        }
        if (ret_data.trade_state === 'SUCCESS') {
            return false;
        }
        const price = order_info.price * 100 - order_info.preferential_price * 100;
        if (price != ret_data.cash_fee) {
            return false;
        }
        await ctx.prometheusModel.CreditPay.edit({ where: { id: pay_info.id }, params: { pay_result: JSON.stringify(ret_data), status: 1 } });

        return true;

    }

    /**
     * @description 支付回调通知
     * @param {*} result 
     */
    async WexinNotify(result) {

        const { ctx } = this;
        // && result.appid === this.config.MCH_APPID
        if (result) {
            let sign_data = {};
            for (let key in result) {
                sign_data[key] = result[key][0];
            }
            if (sign_data.return_code && sign_data.return_code === 'SUCCESS' && sign_data.result_code && sign_data.result_code === 'SUCCESS') {
                const wexin_return_sign = sign_data.sign;
                delete sign_data.sign;
                const sign = this.getSign(sign_data);
                const out_trade_no = sign_data.out_trade_no;
                const total_fee = sign_data.total_fee;
                const pay_info = await ctx.prometheusModel.CreditPay.findOne({ where: { trade_no: out_trade_no }, order: [['id', 'desc']] });
                if (!pay_info || !pay_info.order_id) {
                    ctx.failed('error pay');
                }
                const order = await ctx.prometheusModel.CreditOrder.findOne({ where: { id: pay_info.order_id } });
                if (!order || !order.id) {
                    ctx.failed('error order');
                }
                const price = order.price * 100 - order.preferential_price * 100;

                if (total_fee == price && sign == wexin_return_sign) {
                    const state_time = moment().format('YYYY-MM-DD HH:mm:ss');
                    await ctx.prometheusModel.CreditPay.edit({ where: { id: pay_info.id }, params: { pay_result: JSON.stringify(result), status: 1 } });
                    await ctx.prometheusModel.CreditOrder.update({ state: '已支付', state_time: state_time, pay_status: 1 }, { where: { id: order.id } });
                    console.info('7777777777777777777777');
                    return true;
                }
            }
        }

        return false;
    }

    /**
   * @author lisk
   * @description 参数签名
   * @param {*} params 
   */
    getWexinSign(params) {

        const { ctx, app } = this;
        let ret = [];
        for (let val of Object.keys(params).sort()) {
            ret[val] = params[val];
        }
        let str = '';
        for (let key in ret) {
            str += key + '=' + ret[key] + '&';
        }
        const mch_key = this.config.MCH_KEY;

        const sign = ctx.helper.md5(str + 'key=' + mch_key).toLocaleUpperCase();

        return sign;
    }

}

module.exports = CommonService;
