
'use strict';

const Service = require('egg').Service;
const R = require('ramda');
class DeveloperService extends Service {

    /**
     * 通過城市编号获取小区列表
     * @param {object} condition {type: XX, connect_id: XX}
     * @param {object} elements [id, path, ...]//需要筛选出的元素
     */
    async getDevelopers(condition, elements = []) {

        const { ctx } = this;
        const { city_code, district_code, bizcircle_code } = condition;
        let where = {};

        if (bizcircle_code) {
            const residentials = await ctx.realestateModel.ResidentialDeveloper.all({ where: { region: bizcircle_code } });
            const residentials_ids = R.pluck('developer_id', residentials);
            where.id = { $in: residentials_ids }
        } else if (district_code) {
            const residentials = await ctx.realestateModel.ResidentialDeveloper.all({ where: { county: district_code } });
            const residentials_ids = R.pluck('developer_id', residentials);
            where.id = { $in: residentials_ids }
        } else if (city_code) {
            const residentials = await ctx.realestateModel.ResidentialDeveloper.all({ where: { city: city_code } });
            const residentials_ids = R.pluck('developer_id', residentials);
            where.id = { $in: residentials_ids }
        }

        let ret = await ctx.realestateModel.Developer.all({ where: where });

        if (Array.isArray(elements) && elements.length !== 0) {
            ret = R.project(elements)(ret);
        }
        return ret;
    }

}

module.exports = DeveloperService;
