
'use strict';

const Service = require('egg').Service;

const PRICE_RANGE = {
    1: { name: '2000元以下', min: 0, max: 2000 },
    2: { name: '2000元-3000元', min: 2000, max: 3000 },
    3: { name: '3000元-4000元', min: 3000, max: 4000 },
    4: { name: '4000元-5000元', min: 4000, max: 5000 },
    5: { name: '5000元-6000元', min: 5000, max: 6000 },
    6: { name: '6000元-7000元', min: 6000, max: 7000 },
    7: { name: '7000元-8000元', min: 7000, max: 8000 },
    8: { name: '8000元-10000元', min: 8000, max: 10000 },
    9: { name: '10000元以上', min: 10000, max: 10000000000000 },
}

const HOUSE_TYPE = {
    1: { name: '1室', min: 1, max: 1 },
    2: { name: '2室', min: 2, max: 2 },
    3: { name: '3室', min: 3, max: 3 },
    4: { name: '4室', min: 4, max: 4 },
    5: { name: '5室以上', min: 5, max: 10000 },
    6: { name: '别墅', min: 10000, max: 10000000 },
}

class OptionService extends Service {

    async getOptions(city_code) {

        const { ctx } = this;
        const city = ctx.blockModel.City.one({ where: { code: city_code } });
        if (!city || !city.name) {
            ctx.failed('city code error');
        }
        const district = ctx.blockModel.District.all({ where: { city_id: city.code } });
        if(!district || district){
            ctx.failed('district error');
        }
        const bizcircle = ctx.blockModel.Bizcircle.all({where: {}});
        const developers_results = await ctx.service.houseCommon.developer.all({});
        const developers = developers_results.results;
        const brands = [];
        for (let i in developers) {
            const developer = developers[i];
            brands.push({
                id: developer.id,
                name: developer.name,
                image: developer.logo,
            });
        }
        const house_types = HOUSE_TYPE;
        const prices = PRICE_RANGE;

        return { brands, prices, house_types };
    }
}

module.exports = OptionService;
