
'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;

    const CreditCallriskCallActive = app.prometheusModel.define('credit_callrisk_call_active', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        report_id: {
            type: INTEGER,
            allowNull: false,
        },
        routine_call_time: {
            type: INTEGER,
            allowNull: false,
        },
        night_call_time: {
            type: INTEGER,
            allowNull: false,
        },
        routine_call_count: {
            type: INTEGER,
            allowNull: false,
        },
        night_call_count: {
            type: INTEGER,
            allowNull: false,
        },
        time_interval_active: {
            type: STRING,
            allowNull: true,
            field: 'time_interval_active',
            get() {
                const time_interval_active = this.getDataValue('time_interval_active');
                if (time_interval_active) {
                    try {
                        return JSON.parse(time_interval_active);
                    } catch (error) {
                        return [];
                    }
                }
                return [];
            },
        },
        city_active: {
            type: STRING,
            allowNull: true,
            field: 'city_active',
            get() {
                const city_active = this.getDataValue('city_active');
                if (city_active) {
                    try {
                        return JSON.parse(city_active);
                    } catch (error) {
                        return [];
                    }
                }
                return [];
            },
        },
        // is_deleted: {
        //     type: INTEGER,
        //     allowNull: false,
        // },
        // updated_at: {
        //     type: DATE,
        //     allowNull: true,
        //     get() {
        //         const date = this.getDataValue('updated_at');
        //         return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
        //     },
        // },
        // created_at: {
        //     type: DATE,
        //     allowNull: false,
        //     get() {
        //         const date = this.getDataValue('created_at');
        //         return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
        //     },
        // }
    }, {
            timestamps: false,
            tableName: 'credit_callrisk_call_active',
        });

    CreditCallriskCallActive.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await CreditCallriskCallActive.findOne({
            attributes: attributes,
            where: where,
        });
    }

    CreditCallriskCallActive.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await CreditCallriskCallActive.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    CreditCallriskCallActive.list = async (data = {}) => {
        const limit = data.limit ? Number(data.limit) : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await CreditCallriskCallActive.findAndCountAll(condition);
        return { page, count, rows };
    }

    CreditCallriskCallActive.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await CreditCallriskCallActive.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    CreditCallriskCallActive.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        try {
            const res = await CreditCallriskCallActive.update(params, { where: where })
            return res;
        } catch (error) {
            throw (error);
        }
    }

    return CreditCallriskCallActive;

};