
'use strict';

const Service = require('egg').Service;
const moment = require('moment');

class HotSearchService extends Service {

    /**
     * 热门搜索的关键词允许设置10个，新房和租房的需要区分开
     * @param {*} condition 
     */
    async getHotSearch(condition) {
        const { ctx } = this;
        let type = condition.type;
        let cityCode = condition.city_code;
        let filter = {
            limit: 10,
            attributes: ['text'],
            where: {
                city: cityCode,
                type: type,
                valid: 1
            },
            order: [['created_at', 'desc']]
        }
        let hotSearch = await ctx.realestateModel.HotSearch.all(filter);
        let hotList = hotSearch.map(v => { return v.text });
        let ret = {
            results: hotList,
            count: hotList.length
        }
        return ret;
    }

}

module.exports = HotSearchService;
