'use strict';
const Service = require('egg').Service;
const R = require('ramda');
const moment = require('moment');
class ProductService extends Service {


  // 通过 type=loan/credit 频道 option_ids 筛选项数组 all_product_ids
  // async getProductsByOptions(option_ids, all_product_ids = []) {

  //     const { ctx } = this;
  //     if (!Array.isArray(option_ids) || !option_ids || option_ids.length === 0) {
  //         return all_product_ids;
  //     }
  //     let product_ids = all_product_ids;
  //     for (let i in option_ids) {
  //         const option_id = option_ids[i];
  //         const products = await ctx.service.RecommendChannelProduct.all({ where: { option_id: option_id } });
  //         if (!products || products.length === 0 || Object.keys(products).length === 0) {
  //             continue;
  //         }
  //         const recommend_product_ids = R.pluck(products, 'product_id');
  //         product_ids = R.intersection(product_ids, recommend_product_ids);
  //     }

  //     return product_ids;
  // }

  // 获取筛选项列表 带 product_id
  // return : [{"id":3,"title":"银行分类","description":"信用卡银行分类","_children":[{"id":12,"title":"招商银行","quality":["1"],"normal":["1"]},{"id":16,"title":"广发银行","quality":[],"normal":[]}]},{"id":4,"title":"主题分类","description":"信用卡主题分类","_children":[]},{"id":5,"title":"信用卡筛选项","description":"信用卡筛选项","_children":[]}]
  async getRecommendOptions(type = 'credit', keys = []) {

    const { ctx } = this;
    // const type = 'credit';
    // keys = ['loan_organization', 'loan_filter', 'credit_bank', 'credit_theme', 'credit_filter'];
    // console.info(keys);
    let classifies = await ctx.blockModel.RecommendChannelClassify.all({ where: { type, valid: 1, key: { $in: keys } } });
    // return classifies;
    classifies = R.project([ 'id', 'key', 'title', 'description' ])(classifies);
    const classify_ids = R.pluck('id', classifies);
    let options = await ctx.blockModel.RecommendChannelOption.all({ where: { classify_id: { $in: classify_ids }, status: 'online', valid: 1 }, order: [[ 'order', 'asc' ]] });
    options = R.project([ 'id', 'title', 'classify_id' ])(options);
    const option_ids = R.pluck('id', options);
    let option_products = await ctx.blockModel.RecommendChannelProduct.all({ where: { option_id: { $in: option_ids }, valid: 1 }, order: [[ 'order', 'asc' ]] });
    option_products = R.project([ 'option_id', 'product_id', 'type' ])(option_products);
    const ret = [];
    for (const i in classifies) {
      const classify = classifies[i];
      const classify_id = classify.id;
      let temp_options = options.filter(option => parseInt(option.classify_id) === parseInt(classify_id));
      temp_options = R.project([ 'id', 'title' ])(temp_options);
      for (const j in temp_options) {
        const temp_option = temp_options[j];
        const temp_option_id = temp_option.id;
        let temp_option_products = option_products.filter(v => parseInt(v.option_id) === parseInt(temp_option_id));
        temp_option_products = R.groupBy(v => { return v.type === 'quality' ? 'quality' : 'normal'; })(temp_option_products);
        const quality_product_ids = R.pluck('product_id', temp_option_products.quality ? temp_option_products.quality : []);
        const normal_product_ids = R.pluck('product_id', temp_option_products.normal ? temp_option_products.normal : []);
        temp_options[j].quality = quality_product_ids;
        temp_options[j].normal = normal_product_ids;
      }

      classify._children = temp_options;
      ret.push(classify);
    }

    return ret;
  }

  //
  async getLoanChannelSuitOptions() {
    const { ctx } = this;
    const user_id = ctx.userId;
    const app_user_id = ctx.appUserId;
    const credit_loans = await this.getAllProductsByType(1);
    const common_loans = await this.getAllProductsByType(4);
    const credit_loans_ids = R.pluck('business_id', credit_loans);
    const common_loans_ids = R.pluck('business_id', common_loans);
    const default_options = {
      id: -1,
      key: 'loan_all',
      title: '全部',
      description: '全部',
      _children: [],
    };
    const children = [{ id: -2, title: '全部', quality: credit_loans_ids, normal: common_loans_ids }];
    if (app_user_id) {
      const userGjj = await ctx.helper.send_request(this.config.NODE_BASE_URL + '/cassandra-server/gjj/list/' + user_id, {}, { method: 'GET' });
      if (userGjj.status === 200 && !ctx.isEmpty(userGjj.data.ret)) {
        children.push({
          id: -3,
          title: '最适合您的',
          quality: await this.getSuitLoans(),
          normal: [],
        });
      } else {
        children.push({
          id: -4,
          title: '51公积金贷',
          quality: credit_loans_ids,
          normal: common_loans_ids,
        });
        children.push({
          id: -5,
          title: '普通贷',
          quality: [],
          normal: common_loans_ids,
        });
      }
    } else {
      children.push({
        id: -4,
        title: '51公积金贷',
        quality: credit_loans_ids,
        normal: common_loans_ids,
      });
      children.push({
        id: -5,
        title: '普通贷',
        quality: [],
        normal: common_loans_ids,
      });
    }
    default_options._children = children;

    return default_options;
  }

  // 1 授信贷；2 信用卡；3 普通信用卡；4 普通贷款
  async getAllProductsByType(type) {
    
    const { ctx } = this;
    const url = this.config.NODE_BASE_URL + '/cassandra-server/bu_basic/list';
    
    const products_results = await ctx.helper.send_request(url, { type, app_id: ctx.appId }, { method: 'GET' });
    // ctx.logger.info(JSON.stringify({ url, products_results }));
    let products = [];
    console.log(products_results)
    if (products_results.status !== 200 || !products_results.data || !products_results.data.ret) {
      return products;
    }
    
    products = products_results.data.ret;
    const sort = function(a, b) {
      if (a.recommend_sorter === b.recommend_sorter) {
        return b.business_id - a.business_id;
      }
      return a.recommend_sorter - b.recommend_sorter;
    };
    products = R.sort(sort)(products);
    products = await this.formatProducts(products, type);

    return products;
  }

  // 最适合您的（推荐）贷款
  async getSuitLoans() {
    const results = await this.getBusinessRecommendList(9999);
    const ret = R.pluck('business_id', results);
    return ret;
  }

  // 贷款频道首页热门推荐
  async getLoanHomeList() {
    let ret = await this.getBusinessRecommendList(6, 'home');
    if (ret.length < 6) {
      const creditLoan = R.take(6 - ret.length)(await this.getAllProductsByType(4));
      ret = R.insertAll(ret.length, creditLoan)(ret);
    }
    return ret;
  }

  // 获取用户贷款分组
  async getBusinessClassList() {
    const { ctx } = this;
    const userId = ctx.userId;
    const appUserId = ctx.appUserId;
    const url = ctx.app.config.NODE_BASE_URL + '/cassandra-server/loan_list/bu_class/list';
    const param = { uid: userId, app_uid: appUserId, app_id: ctx.appId };
    const resp = await ctx.helper.send_request(url, param, { method: 'GET' });
    if (resp.status !== 200) {
      ctx.failed('[bu_class]内部接口错误');
    }
    return resp.data.ret;
  }

  // 获取用户贷款通过率
  async getBusinessPassRate(businessList) {
    const { ctx } = this;
    const userId = ctx.userId;
    const appUserId = ctx.appUserId;
    const url = ctx.app.config.NODE_BASE_URL + '/cassandra-server/loan_list/recommend_sort/list';
    const param = { uid: userId, app_uid: appUserId, business_arr: businessList };

    // 判断列表是否为空
    if (businessList.length === 0) {
      return [];
    }

    const resp = await ctx.helper.send_request(url, param, { method: 'POST' });
    if (resp.status !== 201) {
      ctx.failed('[recommend_sort]内部接口错误');
    }

    return resp.data.ret;
  }

  // 获取普通贷款
  async getCommonBusinessList() {
    const { ctx } = this;
    const url = ctx.app.config.NODE_BASE_URL + '/cassandra-server/bu_basic/list';
    const param = { type: 4, app_id: ctx.appId };
    const resp = await ctx.helper.send_request(url, param, { method: 'GET' });
    if (resp.status !== 200) {
      ctx.failed('[bu_basic]内部接口错误');
    }

    return resp.data.ret;
  }

  // 获取推荐列表，按照ABC分组顺序推荐
  async getBusinessRecommendList(limit, location = 'list') {
    const { ctx } = this;
    const userId = ctx.userId;
    const R = require('ramda');
    const recommendSort = function(a, b) {
      if (a.recommend_sorter === b.recommend_sorter) {
        return b.business_id - a.business_id;
      }
      return a.recommend_sorter - b.recommend_sorter;
    };
    let ret = [];
    // 如果未登录或者没有导入公积金，则推荐授信贷
    if (ctx.isEmpty(userId)) {
      // const commonLoanList = await this.getCommonBusinessList();
      const loanList = await this.getAllProductsByType(1);
      ret = R.take(limit)(loanList);
    } else {
      const userGjj = await ctx.helper.send_request(this.config.NODE_BASE_URL + '/cassandra-server/gjj/list/' + userId, {}, { method: 'GET' });
      if (userGjj.status !== 200 || ctx.isEmpty(userGjj.data.ret)) {
        const loanList = await this.getAllProductsByType(1);
        ret = R.take(limit)(loanList);
        return ret;
      }

      // 日志
      const log = {
        user_sid: ctx.oldUserId,
        type: 2,
        need_smart_recommend: 0,
        is_smart_recommend: 0,
        pass_rate_list: '',
        business_list: '',
        c_class_list: '',
        common_loan_list: '',
        page_type: location === 'list' ? 2 : 1,
        is_run_pass_rate: 0,
        created_time: moment(Date()).format('YYYY-MM-DD HH:mm:ss'),
      };

      // 先获取分组
      const classList = await this.getBusinessClassList();

      // 获取开关状态，判断是自动推荐or手动推荐orABTest
      const keyword = location === 'list' ? 'config_list_smart_recommend' : 'config_loan_smart_recommend';
      const ruleSetting = await this.app.huodongModel.Setting.findOne({ where: { keyword } });
      const rule = Number(ruleSetting.value);
      // 是否需要计算模型
      let isNeedCalc = false;
      let userInfo = {};
      let userResult = {};
      switch (rule) {
        case 1:
          isNeedCalc = true;
          break;
        case 2:
          isNeedCalc = false;
          classList.class_C = R.map(function(e) {
            e.class = 'C';
            e.rule = rule;
            e.hasPassRate = 0;
            e.needCalc = 0;
            return e;
          })(classList.class_C);
          break;
        case 3:
          // 获取不到手机号则默认使用手动推荐
          isNeedCalc = false;
          // 获取用户手机号，根据手机号末尾判断是否自动推荐
          userResult = await ctx.helper.send_request(this.config.USER_CENTER_API_URI + '/v1/appusers/' + ctx.appUserId, {}, {
            method: 'GET',
          });
          userInfo = userResult.status === 200 ? userResult.data : {};
          if (!ctx.isEmpty(userInfo) && !ctx.isEmpty(userInfo.user) && !ctx.isEmpty(userInfo.user.phone) && (Number(userInfo.user.phone) % 2 === 0)) {
            isNeedCalc = true;
          } else {
            classList.class_C = R.map(function(e) {
              e.class = 'C';
              e.rule = rule;
              e.hasPassRate = 0;
              e.needCalc = 0;
              return e;
            })(classList.class_C);
          }
          break;
        default:
          break;
      }

      log.type = rule;

      let result = [];
      // 先取A
      if (classList.hasOwnProperty('class_A') && !ctx.isEmpty(classList.class_A)) {
        result = R.take(limit)(R.sort(recommendSort)(classList.class_A));
        result = R.map(function(e) {
          e.class = 'A';
          e.rule = 2;
          return e;
        })(result);
      }
      // 再取B
      if (classList.hasOwnProperty('class_B') && !ctx.isEmpty(classList.class_B)) {
        let classB = R.take(limit - result.length)(R.sort(recommendSort)(classList.class_B));
        classB = R.map(function(e) {
          e.class = 'B';
          e.rule = 2;
          return e;
        })(classB);
        result = R.insertAll(result.length, classB)(result);
      }

      // 如果数量不够，再取C
      if (result.length < limit) {
        // 判断C组是否有值
        if (classList.hasOwnProperty('class_C') && !ctx.isEmpty(classList.class_C)) {
          if (isNeedCalc || rule === 3) {
            const businessArr = R.pluck('business_id')(classList.class_C);
            const passRateList = await this.getBusinessPassRate(businessArr);
            if (!ctx.isEmpty(passRateList)) {
              classList.class_C = R.map(function(e) {
                e.class = 'C';
                e.rule = rule;
                e.hasPassRate = 0;
                e.needCalc = (isNeedCalc || (isNeedCalc && rule === 3)) ? 1 : 0;
                e.pass_rate = 0;
                return e;
              })(classList.class_C);
              for (const v of passRateList) {
                for (let i = 0; i < classList.class_C.length; i++) {
                  if (Number(classList.class_C[i].business_id) === Number(v.business_id)) {
                    classList.class_C[i].pass_rate = v.pass_rate;
                    classList.class_C[i].hasPassRate = 1;// 是否有通过率返回值
                    break;
                  }
                }
              }
              // 根据通过率降序排序
              const passRateSort = function(a, b) {
                if (a.pass_rate === b.pass_rate) {
                  return Number(a.recommend_sorter) - Number(b.recommend_sorter);
                }
                return b.pass_rate - a.pass_rate;
              };

              if (isNeedCalc || (isNeedCalc && rule === 3)) {
                classList.class_C = R.sort(passRateSort)(classList.class_C);
                log.is_smart_recommend = 1;
              } else {
                classList.class_C = R.sort(recommendSort)(classList.class_C);
              }
              log.c_class_list = R.pluck('business_id')(classList.class_C).join(',');
              log.is_run_pass_rate = 1;
              log.pass_rate_list = JSON.stringify(passRateList);
            } else {
              // 模型计算参数不够，仍然采用手动推荐
              classList.class_C = R.sort(recommendSort)(classList.class_C);
              classList.class_C = R.map(function(e) {
                e.class = 'C';
                e.rule = rule;
                e.hasPassRate = 0;
                e.needCalc = (isNeedCalc || (isNeedCalc && rule === 3)) ? 1 : 0;
                return e;
              })(classList.class_C);
              log.c_class_list = R.pluck('business_id')(classList.class_C).join(',');
            }
          } else {
            classList.class_C = R.sort(recommendSort)(classList.class_C);
            log.c_class_list = R.pluck('business_id')(classList.class_C).join(',');
          }
        }
      }

      result = R.insertAll(result.length, R.take(limit - result.length)(classList.class_C))(result);
      ret = await this.formatLoanList(result);

      // 处理log
      log.need_smart_recommend = isNeedCalc ? 1 : 0;
      log.business_list = R.pluck('business_id')(result).join(',');
      await this.app.huodongModel.LogLoanRecommend.create(log);
    }

    return ret;
  }

  async formatLoanList(loanList) {

    //以下代码是为了处理渠道包下不展示特殊的4个业务
    //start
    const { ctx } = this;
    const user_sid =  ctx.oldUserId;
    let filter = { where: { sid: user_sid } };
    let userInfo = await ctx.gjjModel.SysUser.one(filter);
    ctx.logger.info('get_phone_by_user_sid:' + JSON.stringify(userInfo));
    let place_cid = 0;
    if (userInfo !== null) {
      place_cid = userInfo.place_cid;
    } else {
      const jianbing_guest_customer_id = ctx.cookies.get('jianbing_guest_customer_id', { signed: false });
      filter = { where: { sid: jianbing_guest_customer_id } };
      let userInfo = await ctx.gjjModel.SysGuest.one(filter);
      if (userInfo !== null) {
        place_cid = userInfo.place_cid;
      }

    }
    //end

    const ret = [];
    for (const v of loanList) {
      //以下代码是为了处理渠道包下不展示特殊的4个业务
      //start
      let sepecial_business_ids = [95,  7, 130, 51];
      if(place_cid > 0 && place_cid == 2420 && sepecial_business_ids.includes(v.business_id)) {
        continue;
      }
      //end

      // 处理C组
      let url = v.url;
      if (v.hasOwnProperty('class')) {
        if (url.includes('?')) {
          url = url + '&class=' + v.class + '&rule=' + String(v.rule);
        } else {
          url = url + '?class=' + v.class + '&rule=' + String(v.rule);
        }
        if (v.class === 'C') {
          url = url + '&hasPassRate=' + String(v.hasPassRate) + '&needCalc=' + String(v.needCalc) + '&passRate=' + String(v.pass_rate);
        }
      }
      const tmp = {
        type: v.type,
        business_id: v.business_id,
        name: v.name,
        logo: v.logo,
        alias: v.alias,
        rate_title: v.rate_title,
        rate: v.rate,
        min_amount: v.min_amount,
        max_amount: v.max_amount,
        sort: v.recommend_sorter,
        state: v.state,
        url,
        business_notice: v.business_notice,
        feature: v.feature,
        abridge_desc: v.abridge_desc,
        front_image: v.front_image,
        back_image: v.back_image,
      };
      ret.push(tmp);
    }

    return ret;
  }

  async formatProducts(products, type) {
    const { ctx } = this;
    const ret = [];
    const channel = ctx.channel;
    let location = 'loan_channel';
    let city = '';

    if(type == 4) {
      let city_res = await ctx.helper.parseIp();
      if(city_res && city_res.content && city_res.content.address_detail && city_res.content.address_detail.city) {
        city = city_res.content.address_detail.city.replace('市', '');
      }
      ctx.logger.info(city_res)

              
    }
    
    for (const v of products) {
      ctx.logger.info('imh------begin----------')
      if (Number(v.type) === 2 || Number(v.type) === 3) {
        v.rate = '';
        v.rate_title = '';
        location = 'credit_channel';
      }
      const channels = ctx.isEmpty(v.channel_rate_id) ? [] : v.channel_rate_id.split(',');
      // const rate = channels.includes(channel) ? (v.channel_rate.includes('元') || v.channel_rate.includes('%') ? v.channel_rate : v.channel_rate + '%') : (!ctx.isEmpty(v.rate) ? (v.rate.includes('元') || v.rate.includes('%') ? v.rate : v.rate + '%') : '');
      const rate = channels.includes(channel) ? v.channel_rate : v.rate;
      const rateTitle = channels.includes(channel) ? v.channel_rate_title : v.rate_title;
      let url = v.url;
      if (Number(v.type) === 4) {
        url = url.includes('?') ? url + '&from=51gjj_loan_channel' : url + '?from=51gjj_loan_channel';
      }
      url = this.config.PHP_URL + '/app/track/url?url=' + encodeURI(url) + '&source=51gjj&location=' + location;
      ctx.logger.info(v.cities)
      ctx.logger.info(city)
      if(v.cities && v.cities.length > 0 && city != '') {
        ctx.logger.info('imh------222----------')
        if(v.cities.includes(city)) {
          ctx.logger.info('imh----------------')
          const tmp = {
            type: v.type,
            business_id: v.business_id,
            name: v.name,
            logo: v.logo,
            alias: v.alias,
            rate_title: rateTitle,
            rate,
            min_amount: v.min_amount,
            max_amount: v.max_amount,
            sort: v.recommend_sorter,
            state: v.state,
            url,
            business_notice: v.business_notice,
            feature: v.feature,
            abridge_desc: v.abridge_desc,
            front_image: v.front_image,
            back_image: v.back_image,
          };
          ret.push(tmp);
        }
        
      } else {
        const tmp = {
          type: v.type,
          business_id: v.business_id,
          name: v.name,
          logo: v.logo,
          alias: v.alias,
          rate_title: rateTitle,
          rate,
          min_amount: v.min_amount,
          max_amount: v.max_amount,
          sort: v.recommend_sorter,
          state: v.state,
          url,
          business_notice: v.business_notice,
          feature: v.feature,
          abridge_desc: v.abridge_desc,
          front_image: v.front_image,
          back_image: v.back_image,
        };
        ret.push(tmp);
      }


      ctx.logger.info('imh------end----------')
      
    }

    return ret;
  }
}

module.exports = ProductService;
