'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE } = app.Sequelize;
    const CdLotteryUserQuery = app.realestateModel.define('cd_lottery_user_query', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        user_id: {
            type: STRING,
            allowNull: true
        },
        app_user_id: {
            type: STRING,
            allowNull: true
        },
        app_id: {
            type: STRING,
            allowNull: true
        },
        app_type_id: {
            type: STRING,
            allowNull: true
        },
        house_name: {
            type: STRING,
            allowNull: true
        },
        notarization_no: {
            type: STRING,
            allowNull: true
        },
        phone: {
            type: STRING,
            allowNull: true
        },
        publicise_id: {
            type: INTEGER,
            allowNull: true
        },
        valid: {
            type: INTEGER,
            allowNull: true
        },
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
    }, {
            timestamps: false,
            tableName: 'cd_lottery_user_query',
        });

    return CdLotteryUserQuery;

};
