'use strict';
module.exports = app => {
  const { STRING, INTEGER } = app.Sequelize;

  const HousePriceCity = app.blockModel.define('house_price_city', {
    id: {
      type: INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    price: INTEGER,
  }, {
    timestamps: false,
    tableName: 'house_price_city',
    freezeTableName: true,
  });

  HousePriceCity.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HousePriceCity.findOne({
      attributes: attributes,
      where : where,
    });
  }


  HousePriceCity.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HousePriceCity.findAll({
      attributes: attributes,
      where : where,
    });
  }

  HousePriceCity.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };

    const { count, rows } =  await HousePriceCity.findAndCountAll(condition);
    return { page, count, rows };
  }

  HousePriceCity.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await HousePriceCity.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;  
    } catch(error) {
      ctx.status = 500;
      throw (error);
    }    
  }

  HousePriceCity.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    HousePriceCity.update(params, {
      where: where
    }).catch( e => res.json({status: 500, error: e}));
  }

  return HousePriceCity;

};
