'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, ENUM } = app.Sequelize;

  const CourseLogUser = app.classModel.define('course_log_user', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    user_uuid: STRING,
    type: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_log_user',
  });

  return CourseLogUser;

};
