'use strict';

const moment = require('moment');

module.exports = app => {
    const { INTEGER, STRING, DATE, TEXT } = app.Sequelize;
    const CreditBlackListReport = app.prometheusModel.define('credit_blacklist_report', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        report_no: STRING,
        name: STRING,
        id_card: STRING,
        phone: STRING,
        age: INTEGER,
        city: STRING,
        blacklist_of_internet_loans: INTEGER,
        blacklist_of_court_dishonesty: INTEGER,
        blacklist_of_industry: INTEGER,
        blacklist_of_ds_industry: INTEGER,
        blacklist_of_bx_industry: INTEGER,
        blacklist_of_zc_industry: INTEGER,
        blacklist_of_zf_industry: INTEGER,
        blacklist_of_jd_industry: INTEGER,
        reg_count_1month: INTEGER,
        reg_count_3month: INTEGER,
        reg_count_6month: INTEGER,
        consume_reg_count_1month: INTEGER,
        consume_reg_count_3month: INTEGER,
        consume_reg_count_6month: INTEGER,
        loan_reg_count_1month: INTEGER,
        loan_reg_count_3month: INTEGER,
        loan_reg_count_6month: INTEGER,
        consume_reg_platform_count_1month: INTEGER,
        consume_reg_platform_count_3month: INTEGER,
        consume_reg_platform_count_6month: INTEGER,
        loan_reg_platform_count_1month: INTEGER,
        loan_reg_platform_count_3month: INTEGER,
        loan_reg_platform_count_6month: INTEGER,
        reg_platform_count_1month: INTEGER,
        reg_platform_count_3month: INTEGER,
        reg_platform_count_6month: INTEGER,
        credit_count_1month: INTEGER,
        credit_count_3month: INTEGER,
        credit_count_6month: INTEGER,
        credit_amount_1month: STRING,
        credit_amount_3month: STRING,
        credit_amount_6month: STRING,
        credit_closed_count_1month: INTEGER,
        credit_closed_count_3month: INTEGER,
        credit_closed_count_6month: INTEGER,
        credit_closed_amount_1month: STRING,
        credit_closed_amount_3month: STRING,
        credit_closed_amount_6month: STRING,
        consume_credit_count_1month: INTEGER,
        consume_credit_count_3month: INTEGER,
        consume_credit_count_6month: INTEGER,
        loan_credit_count_1month: INTEGER,
        loan_credit_count_3month: INTEGER,
        loan_credit_count_6month: INTEGER,
        consume_credit_platform_count_1month: INTEGER,
        consume_credit_platform_count_3month: INTEGER,
        consume_credit_platform_count_6month: INTEGER,
        loan_credit_platform_count_1month: INTEGER,
        loan_credit_platform_count_3month: INTEGER,
        loan_credit_platform_count_6month: INTEGER,
        credit_platform_count_1month: INTEGER,
        credit_platform_count_3month: INTEGER,
        credit_platform_count_6month: INTEGER,
        id_card_relevant_mobilephone_count: INTEGER,
        id_card_relevant_device_count: INTEGER,
        mobilephone_relevant_id_card_count: INTEGER,
        relevant_loan_app_count_6month: INTEGER,
        relevant_gamble_app_count_6month: INTEGER,
        relevant_ip_app_count_6month: INTEGER,
        relevant_other_app_count_6month: INTEGER,
        overdue: TEXT,

        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'credit_blacklist_report',
        });

    return CreditBlackListReport;

};
