
'use strict';

const Service = require('egg').Service;

class ResidentialService extends Service {


    async getResidential(id) {
        const { ctx, service } = this;
        let residentialInfo = await service.houseCommon.residential.one(id);
        return residentialInfo;
    }

    //通过开发商id获取小区列表
    async getResidentialByDeveloper(condition, elements = []) {

        const { ctx } = this;
        const { developer_id } = condition;
        if (!developer_id) {
            return [];
        }
        const residential_developer = await ctx.realestateModel.ResidentialDeveloper.all({ where: { developer_id: developer_id, status: 'online', valid: 1 } });
        const residential_ids = R.pluck('residential_id', residential_developer);
        if (residential_ids.length === 0) {
            return [];
        }
        let residentials = await ctx.realestateModel.Residential.all({ where: { id: { $in: residential_ids }, status: 'online', valid: 1 } });

        if (Array.isArray(elements) && elements.length !== 0) {
            residentials = R.project(elements)(residentials);
        }

        return residentials;

    }



}

module.exports = ResidentialService;
