
'use strict';

const Service = require('egg').Service;
const moment = require('moment');

class NewHouseService extends Service {

    /**
     * 根据不同筛选获取列表
     * @param {*} type 四种默认的按钮筛选 全部all 在售sale 最近开盘open 优惠favourable 首页home
     */
    async getNewHouseList(type) {
        const { ctx } = this;
        let types = ['all', 'sale', 'open', 'favourable', 'home'];
        if (!types.includes(type)) {
            ctx.failed('error list type');
        }
        let newHouseList = [];
        if (type === 'home') {
            //为您推荐只展示50条在售楼盘的数据，根据排序序号取数，数字小的排在前面，数字一样的情况下根据时间逆序排列，时间也一样的情况下随机排列；
            let condition = { pageSize: 50 };
            newHouseList = await this.getNewHouseByFilter(condition);
        } else if (type === 'all') {

        } else if (type === 'sale') {

        } else if (type === 'open') {
            //只展示最近三个月内开盘的楼盘，往前追溯三个月,列表单次加载30条楼盘数据，滑到底部再次加载30条
            let endDate = moment().subtract(30, 'days').format('YYYY-MM-DD HH:mm:ss');
            let condition = {
                queryConditions: [{
                    key: "openDate",
                    value: endDate,
                    operator: "greater"
                }],
            };
            newHouseList = await this.getNewHouseByFilter(condition);
        } else if (type === 'favourable') {
            //点击优惠好盘只展示有优惠的楼盘,列表单次加载30条楼盘数据，滑到底部再次加载30条
            let condition = {
                queryConditions: [{
                    key: "favourableInfo",
                    value: false,
                    operator: "isnull"
                }],
            };
            newHouseList = await this.getNewHouseByFilter(condition);
        }
        return newHouseList;
    }

    /**
     * 新房信息
     * @param {string} id 新房id
     */
    async getNewHouse(id) {
        const { ctx, service } = this;
        let newHouseInfo = await service.houseCommon.newHouse.one(id);
        let filter = {
            pageIndex: 1,
            pageSize: 100,
            queryConditions: [{
                key: "state",
                value: 1,
                operator: "equal"
            }, {
                key: "type",
                value: 1,
                operator: "equal"
            }, {
                key: "connectId",
                value: id,
                operator: "equal"
            }],
            orderConditions: [],
        }
        let newHouseImages = await service.houseCommon.houseImage.all(filter);
        let images = [];
        if (newHouseImages.rowCount > 0) {
            for (let i in newHouseImages.results) {
                images.push(newHouseImages.results[i].path);
            }
        }
        newHouseInfo.images = images;
        //TODO对数据格式化处理
        return newHouseInfo;
    }

    /**
     * 通过NewHouseId获取新房户型信息
     * @param {*} id 
     */
    async getNewHouseType(id) {
        const { ctx, service } = this;
        let filter = {
            pageIndex: 1,
            pageSize: 999,
            queryConditions: [{
                key: "state",
                value: 1,
                operator: "equal"
            }, {
                key: "newHouseId",
                value: id,
                operator: "equal"
            }],
            orderConditions: [],
        }
        let newHouseTypeList = await service.houseCommon.newHouseType.all(filter);
        //TODO需要根据几居室区分
        let ret = {
            results: newHouseTypeList.results,
            count: newHouseTypeList.rowCount
        };
        return ret;
    }

    /**
     * 根据筛选条件newHouseType列表来获取newHouse
     * @param {*} condition 
     */
    async getNewHouseByTypeFilter(condition) {
        const { ctx, service } = this;
        let page = Number(condition.page) || 1;
        let pageSize = Number(condition.pageSize) || 30;
        let filter = {
            pageIndex: page,
            pageSize: pageSize,
            queryConditions: [{
                key: "state",
                value: 1,
                operator: "equal"
            }],
            orderConditions: [{
                key: 'orderNum',
                orderSequence: 'asc',
            },
            {
                key: 'createdAt',
                orderSequence: 'desc',
            }],
        }
        //根是否有值来增加筛选项
        if (condition.unitPrice) {//单价
            filter.queryConditions.push(
                {
                    key: 'referenceAvgPrice',
                    value: condition.unitPrice.min,
                    operator: 'greaterEqual',
                },
                {
                    key: 'referenceAvgPrice',
                    value: condition.unitPrice.max,
                    operator: 'lessEqual',
                }
            );
        }
        if (condition.totalPrice) {//总价
            filter.queryConditions.push(
                {
                    key: 'referenceTotalPrice',
                    value: condition.totalPrice.min,
                    operator: 'greaterEqual',
                },
                {
                    key: 'referenceTotalPrice',
                    value: condition.totalPrice.max,
                    operator: 'lessEqual',
                }
            );
        }
        if (condition.area) {//面积
            filter.queryConditions.push(
                {
                    key: 'area',
                    value: condition.area.min,
                    operator: 'greaterEqual',
                },
                {
                    key: 'area',
                    value: condition.area.min,
                    operator: 'lessEqual',
                })
                ;
        }
        if (condition.type) {//户型
            filter.queryConditions.push({
                key: 'Apartment',
                value: condition.type,
                operator: 'equal',
            });
        }
        let newHouseTypeList = await service.houseCommon.newHouse.all(filter);
        let list = [];
        if (newHouseTypeList.rowCount !== 0) {
            for (let i in newHouseTypeList) {
                let newHouseInfo = await service.houseCommon.newHouse.one(newHouseTypeList[i].NewHouseId);
                if (newHouseInfo.length > 0) {
                    let tmp = {
                        id: newHouseInfo.id,
                        name: newHouseInfo.name,
                        address: newHouseInfo.address,
                        tags: newHouseInfo.tags,
                        name: newHouseInfo.Image,
                    }
                    list.push(tmp);
                }
            }
        }
        let ret = {
            results: list,
            count: list.length
        };
        return ret;
    }

    async getNewHouseByFilter(condition) {
        const { ctx, service } = this;
        let page = Number(condition.page) || 1;
        let pageSize = Number(condition.pageSize) || 30;
        let filter = {
            pageIndex: page,
            pageSize: pageSize,
            queryConditions: [{
                key: "state",
                value: 1,
                operator: "equal"
            },],
            orderConditions: [{
                key: 'orderNum',
                orderSequence: 'asc',
            },
            {
                key: 'createdAt',
                orderSequence: 'desc',
            },],
        }
        if (condition.hasOwnProperty('queryConditions')) {
            filter.queryConditions = filter.queryConditions.concat(condition.queryConditions);
        }
        if (condition.hasOwnProperty('orderConditions')) {
            filter.orderConditions = filter.orderConditions.concat(condition.orderConditions);
        }
        let newHouseList = await service.houseCommon.newHouse.all(filter);
        let list = [];
        if (newHouseList.rowCount > 0) {
            for (let i in newHouseList.results) {
                let tmp = {
                    id: newHouseList.results[i].id,
                    name: newHouseList.results[i].name,
                    address: newHouseList.results[i].address,
                    tags: newHouseList.results[i].tags,
                    image: newHouseList.results[i].image,
                };
                list.push(tmp);
            }
        }
        let ret = {
            results: list,
            count: list.length
        };
        return ret;
    }

}

module.exports = NewHouseService;
