
'use strict';

const Service = require('egg').Service;

const PRICE_RANGE = [
    { name: '不限', min: 0, max: 0 },
    { name: '2000元以下', min: 0, max: 2000 },
    { name: '2000元-3000元', min: 2000, max: 3000 },
    { name: '3000元-4000元', min: 3000, max: 4000 },
    { name: '4000元-5000元', min: 4000, max: 5000 },
    { name: '5000元-6000元', min: 5000, max: 6000 },
    { name: '6000元-7000元', min: 6000, max: 7000 },
    { name: '7000元-8000元', min: 7000, max: 8000 },
    { name: '8000元-10000元', min: 8000, max: 10000 },
    { name: '10000元以上', min: 10000, max: 10000000000000 },
]

const HOUSE_TYPE = [
    { name: '不限', min: 0, max: 0, value: 0, },
    { name: '1室', min: 1, max: 1, value: 1, },
    { name: '2室', min: 2, max: 2, value: 2, },
    { name: '3室', min: 3, max: 3, value: 3, },
    { name: '4室', min: 4, max: 4, value: 4, },
    { name: '5室', min: 4, max: 4, value: 5, },
    { name: '5室以上', min: 5, max: 10000, value: 6, },
    { name: '别墅', min: 10000, max: 10000000, value: 7, },
]

const NEW_HOUSE_UNIT_PRICE = [
    { name: '不限', min: 0, max: 0 },
    { name: '1万以下', min: 0, max: 10000 },
    { name: '1万-2万', min: 10000, max: 20000 },
    { name: '2万-3万', min: 20000, max: 30000 },
    { name: '3万-4万', min: 30000, max: 40000 },
    { name: '4万-5万', min: 40000, max: 50000 },
    { name: '5万-6万', min: 60000, max: 70000 },
]

const NEW_HOUSE_TOTAL_PRICE = [
    { name: '不限', min: 0, max: 0 },
    { name: '100万以下', min: 0, max: 100 },
    { name: '100万-200万', min: 100, max: 200 },
    { name: '200万-300万', min: 200, max: 300 },
    { name: '300万-400万', min: 300, max: 400 },
    { name: '400万-500万', min: 400, max: 500 },
    { name: '500万-600万', min: 500, max: 600 },
    { name: '600万-700万', min: 600, max: 700 },
    { name: '700万-800万', min: 700, max: 800 },
    { name: '800万-900万', min: 800, max: 900 },
    { name: '900万-1000万', min: 900, max: 1000 },
    { name: '1000万以上', min: 1000, max: 0 },
]

const NEW_HOUSE_AREA = [
    { name: '不限', min: 0, max: 0 },
    { name: '50平米以下', min: 0, max: 50 },
    { name: '50平米-70平米', min: 50, max: 70 },
    { name: '70平米-90平米', min: 70, max: 90 },
    { name: '90平米-120平米', min: 90, max: 120 },
    { name: '120平米-150平米', min: 120, max: 150 },
    { name: '150平米-200平米', min: 150, max: 200 },
    { name: '200平米以上', min: 200, max: 999 }
]

class OptionService extends Service {

    //获取筛选项
    async getOptions(city_code) {

        const brands = await this.getDevelopers();
        const house_types = HOUSE_TYPE;
        const prices = PRICE_RANGE;
        const areas = await this.getAreaOptions(city_code);

        return { result: { brands, prices, house_types, areas } };
    }

    //获取新房的筛选项
    async getNewHouseOptions(city_code) {
        const unit_price = NEW_HOUSE_UNIT_PRICE;
        const total_price = NEW_HOUSE_UNIT_PRICE;
        const house_types = HOUSE_TYPE;
        const house_area = NEW_HOUSE_AREA;
        const areas = await this.getAreaOptions(city_code);

        return { result: { house_area, unit_price, total_price, house_types, areas } };
    }

    //获取开发商列表
    async getDevelopers() {

        const { ctx } = this;
        const developers_results = await ctx.service.houseCommon.developer.all({});
        const developers = developers_results.results;
        const ret = [];
        for (let i in developers) {
            const developer = developers[i];
            ret.push({
                id: developer.id,
                name: developer.name,
                image: developer.logo,
            });
        }

        return ret;
    }

    //获取区域商圈
    async getAreaOptions(city_code) {
        const { ctx } = this;
        const city = await ctx.blockModel.City.one({ where: { code: city_code } });
        if (!city || !city.name) {
            ctx.failed('city code error');
        }
        const districts = await ctx.blockModel.HouseDistrict.all({ where: { city_id: city.code } });
        if (!districts || districts.length === 0) {
            ctx.failed('district error');
        }

        const ret = []
        for (let j in districts) {
            const district = districts[j];
            const _children = [];
            const bizcircles = await ctx.blockModel.HouseBizcircle.all({ where: { district_id: district.id } });
            if (!bizcircles || bizcircles.length === 0) {
                continue;
            }
            for (let i in bizcircles) {
                const bizcircle = bizcircles[i];
                _children.push({
                    id: bizcircle.id,
                    area_name: bizcircle.name,
                    // district_id: bizcircle.district_id,
                });
            }
            ret.push({
                id: district.id,
                area_name: district.name,
                // city_id: district.city_id,
                _children: _children,
            })

        }

        return ret;
    }
}

module.exports = OptionService;
