'use strict';

const Controller = require('egg').Controller;
const uuidv4 = require('uuid/v4');
class UserController extends Controller {


  async auth() {

    const { ctx, app } = this;
    const code = ctx.request.body.code;
    if (!code) {
      ctx.failed('error code');
    }

    // 请求微信授权 获取openid
    const wx_auth_ret = await ctx.service.course.v4.user.requestWxAuth(code);
    const openid = wx_auth_ret.openid;// 获取openid
    const session_key = wx_auth_ret.session_key;

    // 检查是否已授权过 是否已入用户表
    let user = await ctx.classModel.V4.CourseUser.one({ where: { openid, is_deleted: 0 } });
    if (!user || !user.uuid) {
      const uuid = uuidv4();
      user = await ctx.classModel.V4.CourseUser.create({ uuid, openid });
      // user.uuid = uuid;
    }
    console.info(user);
    // 存储缓存标识
    const user_uuid = user.uuid;
    const key = 'course_v4_user_session_' + user_uuid;
    await app.memcache.set(key, { user_uuid, openid, session_key });
    const auth_token = ctx.helper.md5(openid + user_uuid + 'jbwl');
    ctx.set('uuid', key);
    ctx.set('auth_token', auth_token);

    const result = { uuid: user_uuid, auth_token };

    ctx.success({ result });

  }

  async registerUserInfo() {
    const { ctx, service } = this;
    const input_params = ctx.request.body;
    const { avatar, nickname, province, country, sex, city } = input_params;
    const encryptedData = input_params.encryptedData || '';
    const iv = input_params.iv || '';
    const params = { avatar, nickname, province, country, sex, city, encryptedData, iv };

    const ret = await service.course.v4.user.registerUserInfo(params);
    ctx.success(ret);
  }

  /**
     * 获取baby信息
     */
  async getBabyInfo() {

    const { ctx } = this;
    const result = await ctx.service.course.v4.user.getBabyInfo();

    ctx.success({ result });
  }

  /**
     * 保存baby信息
     */
  async saveBabyInfo() {

    const { ctx } = this;
    const input_params = ctx.request.body;
    const result = await ctx.service.course.v4.user.saveBabyInfo(input_params);

    ctx.success({ result });
  }

  /**
     * 删除baby信息
     */
  async delBabyInfo() {

    const { ctx } = this;
    const result = await ctx.service.course.v4.user.delBabyInfo();

    ctx.success({ result });
  }

  /**
     * 用户收藏机构列表
     */
  async getCollectInstitutions() {

    const { ctx } = this;
    let input_params = ctx.request.body;
    input_params = Object.assign(input_params, ctx.request.query);
    const result = await ctx.service.course.v4.user.getCollectInstitutions(input_params);

    ctx.success({ result });
  }

  /**
     * 收藏机构
     */
  async collectInstitution() {

    const { ctx } = this;
    const institution_id = ctx.request.body.institution_id;
    if (!institution_id) {
      ctx.failed('error institution_id');
    }
    const result = await ctx.service.course.v4.user.collectInstitution(institution_id);

    ctx.success({ result });
  }

  /**
    * 取消收藏机构
    */
  async delCollectInstitution() {

    const { ctx } = this;
    const institution_id = ctx.request.body.institution_id;
    if (!institution_id) {
      ctx.failed('error institution_id');
    }
    const result = await ctx.service.course.v4.user.delCollectInstitution(institution_id);

    ctx.success({ result });
  }


  async getCollectClasses() {

    const { ctx } = this;
    let input_params = ctx.request.body;
    input_params = Object.assign(input_params, ctx.request.query);
    const result = await ctx.service.course.v4.user.getCollectClasses(input_params);

    ctx.success({ result });
  }

  /**
     * 收藏课程
     */
  async collectClass() {

    const { ctx } = this;
    const class_id = ctx.request.body.class_id;
    if (!class_id) {
      ctx.failed('error class_id');
    }
    const result = await ctx.service.course.v4.user.collectClass(class_id);

    ctx.success({ result });
  }

  /**
    * 取消收藏课程
    */
  async delCollectClass() {

    const { ctx } = this;
    const class_id = ctx.request.body.class_id;
    if (!class_id) {
      ctx.failed('error class_id');
    }
    const result = await ctx.service.course.v4.user.delCollectClass(class_id);

    ctx.success({ result });
  }

  // 获取用户信息
  async getUserInfo() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;
    const ret = await service.course.v4.user.getUserInfo(inputParams);

    ctx.success(ret);
  }
}

module.exports = UserController;
