'use strict';

const Controller = require('egg').Controller;

class NewsController extends Controller {
    /**
     * 获取资讯内容
     */
    async getNews() {
        const { ctx } = this;
        let inputParams = ctx.params;
        let rule = {
            id: { type: 'string', required: true },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.cd.news.getNews(Number(inputParams.id));
        ctx.success(ret);
    }

    /**
     * 获取资讯内容
     */
    async getNewsList() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        let rule = {
            page: { type: 'number', required: true },
            limit: { type: 'number', required: true },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.cd.news.getList(inputParams);
        ctx.success(ret);
    }


}

module.exports = NewsController;
