'use strict';

const Controller = require('egg').Controller;

class InstitutionController extends Controller {
  // 课程列表
  async getClassList() {
    const { ctx } = this;
    const queryParams = ctx.request.query;
    const ret = await ctx.service.course.v5.institution.getClassList(queryParams);

    ctx.success(ret);
  }

  // 课程详情
  async getClassInfo() {
    const { ctx } = this;
    const class_id = ctx.params.class_id;
    if (!class_id) {
      ctx.failed('error class_id');
    }
    const ret = await ctx.service.course.v5.institution.getClassInfo(class_id);

    ctx.success(ret);
  }

  // 收藏课程列表
  async getCollectionClassList() {
    const { ctx } = this;
    const queryParams = ctx.request.query;
    const ret = await ctx.service.course.v5.institution.getCollectionClassList(queryParams);

    ctx.success(ret);
  }

  // 收藏课程
  async collectClass() {
    const { ctx } = this;
    const class_id = ctx.params.class_id;
    if (!class_id) {
      ctx.failed('error class_id');
    }
    const ret = await ctx.service.course.v5.institution.collectClass(class_id);

    ctx.success(ret);
  }

  // 取消收藏课程
  async delCollectClass() {
    const { ctx } = this;
    const class_id = ctx.params.class_id;
    if (!class_id) {
      ctx.failed('error class_id');
    }
    const ret = await ctx.service.course.v5.institution.delCollectClass(class_id);

    ctx.success(ret);
  }

  // 获取科普文章
  async getArticleByCategory() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;
    if (ctx.isEmpty(queryParams) || ctx.isEmpty(queryParams.cat_id)) {
      ctx.failed('cat_id is empty');
    }

    const ret = await service.course.v5.institution.getArticleByCategory(queryParams.cat_id);

    ctx.success(ret);
  }
}

module.exports = InstitutionController;
