'use strict';

const Controller = require('egg').Controller;

class ReportController extends Controller {
  // 获取问题列表
  async getQuestionList() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;
    if (ctx.isEmpty(queryParams) || ctx.isEmpty(queryParams.cat_id)) {
      ctx.failed('cat_id is empty');
    }

    const ret = await service.course.v5.report.getQuestionList(queryParams.cat_id);
    ctx.success(ret);
  }
}

module.exports = ReportController;
