'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;

  const CourseV5Question = app.classModel.define('course_v5_question', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    cat_id: INTEGER,
    title: STRING,
    style: INTEGER,
    type: INTEGER,
    sort: INTEGER,
    status: INTEGER,
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_v5_question',
  });

  return CourseV5Question;

};
