'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE } = app.Sequelize;
    const CdLotteryPublicise = app.realestateModel.define('cd_lottery_publicise', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        house_name: {
            type: STRING,
            allowNull: true
        },
        times: {
            type: INTEGER,
            allowNull: true
        },
        select_order: {
            type: INTEGER,
            allowNull: true
        },
        notarization_no: {
            type: STRING,
            allowNull: true
        },
        register_no: {
            type: STRING,
            allowNull: true
        },
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'cd_lottery_publicise',
        });

    return CdLotteryPublicise;

};
