
'use strict';

const Service = require('egg').Service;
const R = require('ramda');
const _ = require('lodash');

class ReportService extends Service {
  // 获取问题列表
  async getQuestionList(catId) {
    const { ctx } = this;

    const questionList = await ctx.classModel.V5.CourseV5Question.findAll({ where: { cat_id: catId, status: 1, is_deleted: 0 }, order: [[ 'sort', 'asc' ]] });
    if (ctx.isEmpty(questionList)) {
      return { list: [] };
    }

    // 获取所有选项
    let answerList = await ctx.classModel.V5.CourseV5Answer.findAll({ where: { question_id: { $in: R.pluck('id', questionList) }, status: 1, is_deleted: 0 }, attributes: [ 'id', 'question_id', 'title', 'sub_title', 'selected_icon', 'unselected_icon' ], order: [[ 'sort', 'asc' ]] });
    answerList = _.groupBy(answerList, 'question_id');

    const results = [];
    let number = 1;
    for (const v of questionList) {
      results.push({
        id: v.id,
        number: number++,
        cat_id: v.cat_id,
        title: v.title,
        style: v.style,
        type: v.type,
        answer: ctx.isEmpty(answerList[v.id]) ? [] : answerList[v.id],
      });
    }

    const ret = {
      list: results,
    };

    return ret;
  }
}

module.exports = ReportService;
