'use strict';

const moment = require('moment');

module.exports = app => {
  const { INTEGER, DATE } = app.Sequelize;
  const SignIn = app.huodongModel.define('sys_user_score_sign_in', {
    id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    user_sid: INTEGER(11),
    sign_in: INTEGER(11),
    count: INTEGER(11),
    start_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('start_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'sys_user_score_sign_in',
  });

  return SignIn;
};
