'use strict';
module.exports = app => {
  const { STRING, INTEGER } = app.Sequelize;

  const City = app.blockModel.define('city', {
    id: {
      type: INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    name: STRING,
    code: INTEGER,
    level: INTEGER,
    parent: INTEGER,
    fword: STRING,
    hot: INTEGER,
  }, {
    timestamps: false,
    tableName: 'city',
    freezeTableName: true,
  });

  City.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await City.findOne({
      attributes: attributes,
      where : where,
    });
  }


  City.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await City.findAll({
      attributes: attributes,
      where : where,
    });
  }

  City.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };
    console.log(condition);
    const { count, rows } =  await City.findAndCountAll(condition);
    return { page, count, rows };
  }

  City.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await City.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;  
    } catch(error) {
      ctx.status = 500;
      throw (error);
    }    
  }

  City.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    City.update(params, {
      where: where
    }).catch( e => res.json({status: 500, error: e}));
  }

  return City;

};
