'use strict';
const Service = require('egg').Service;

class JobService extends Service {
  async get_info(condition = {}) {
    const { ctx } = this;
    const job_id      = condition.job_id ? condition.job_id : '';
    
    //获得职位的信息
		var job = job_id ? await ctx.blockModel.OfficialJob.one({
			where: {
        id : job_id, //
        status: 1,//在线
        is_deleted: 0,//未删除
			},
			attributes: ['id', 'name', 'duty', 'demand', 'salary', 'experience', 'grade'],
		}) : {};
		//当职位的信息不存在时，或者已经下线时，是空的
		if(!job) {
			return {};
    } 
    
    return job;
  }

  async get_list(condition = {}) {
    const { ctx } = this;
    let { job_type_id } = {
      job_type_id : condition.job_type_id ? condition.job_type_id : '',
      // job_type  : condition.job_type ? condition.job_type : '',      
    }


    if(job_type_id == '') return {};
    var where = {};
    const attributes = ['id', 'name', 'duty', 'demand', 'salary', 'experience', 'grade'];
    where.job_type_id = job_type_id;
    //where.job_type = job_type;
    where.status = 1;//在线
    where.is_deleted = 0;//未删除
    var data = {where , attributes};
    var jobs = await ctx.blockModel.OfficialJob.all(data); 

    if(!jobs) return {};
    
    return jobs;
  }

}

module.exports = JobService;