'use strict';

const Controller = require('egg').Controller;

class BlacklistController extends Controller {

    /**
     * 获取黑名单报告
     */
    async getBlacklistReport() {
        const { ctx } = this;
        let inputParams = ctx.params;
        if (!inputParams.report_id) {
            ctx.failed('empty report id');
        }
        let ret = await ctx.service.credit.blacklist.getReport(inputParams.report_id);
        ctx.success(ret);
    }

    /**
     * 获取验证码
     */
    async getBlacklistReportVerificationCode() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            name: { type: 'string', required: true },
            phone: { type: 'string', required: true },
            id_card: { type: 'string', required: true },
        }
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.credit.apply.getVerificationCode(inputParams);
        ctx.success(ret);
    }


    /**
     * 获取数据报告信息
     */
    async applyBlacklistReport() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            name: { type: 'string', required: true },
            phone: { type: 'string', required: true },
            id_card: { type: 'string', required: true },
            code: { type: 'string', required: true }
        }
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.credit.apply.applyBlacklist(inputParams);
        ctx.success(ret);
    }


}

module.exports = BlacklistController;
