'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, DECIMAL } = app.Sequelize;
  const ShadowSalary = app.huodongModel.define('shadow_salary', {
    id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    user_id: STRING,
    date: STRING,
    base_pay: DECIMAL,
    merit_pay: DECIMAL,
    meal_allowance: DECIMAL,
    other_allowance: DECIMAL,
    heat_allowance: DECIMAL,
    attendance_deduction: DECIMAL,
    shebao_deduction: DECIMAL,
    gjj_deduction: DECIMAL,
    personal_income: DECIMAL,
    sum: DECIMAL,
    status: INTEGER,
    created_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'shadow_salary',
  });

  return ShadowSalary;
};
