'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;

  const CourseActImage = app.classModel.define('course_act_image', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    name: STRING,
    class_id: INTEGER,
    institution_id: INTEGER,
    title: STRING,
    content: STRING,
    selected_image: STRING,
    unselected_image: STRING,
    sort: INTEGER,
    status: INTEGER,
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_act_image',
  });

  return CourseActImage;

};
