'use strict';

const Controller = require('egg').Controller;

class HouseAnalysisController extends Controller {

    //购房解析列表
    async getHouseAnalysisList() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        if (!input_params.city_code) {
            ctx.failed('city_code error');
        }
        let results = await ctx.service.house.v2.houseAnalysis.getHouseAnalysisByFilter(input_params);
        const format_rows = await ctx.service.house.v2.houseAnalysis.formatHouseAnalysis(results.results);
        results.results = format_rows;
        ctx.success(results);
    }

    //购房解析详情
    async getHouseAnalysisInfo() {

        const { ctx } = this;
        const house_analysis_id = ctx.params.house_analysis_id;
        const city_code = ctx.query.city_code;
        const results = await ctx.service.house.v2.houseAnalysis.getHouseAnalysis(house_analysis_id);

        //推荐楼盘
        let where = { corner: { $ne: '' } };
        if (city_code) {
            where.option_city_code = city_code;
        }
        let new_houses_rows = await ctx.realestateModel.NewHouse.list({ page: 1, limit: 3, where: where, order: [['order_id', 'asc']] });
        const similar_list = [];
        for (let i in new_houses_rows.rows) {
            const new_house = new_houses_rows.rows[i];
            similar_list.push({
                id: new_house.id,
                name: new_house.name,
                image: new_house.image,
                corner: new_house.corner,
            });
        }

        ctx.success({ results: { info: results, similar_list } });
    }

    async uploadHouseAnalysis() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const rule = {
            name: { type: 'string', required: true },
            city_code: { type: 'string', required: true },
            house_type: { type: 'string', required: true },
            area: { type: 'string', required: true },
            image: { type: 'string', required: true },
        }
        ctx.validate(rule, input_params);
        const result = await ctx.service.house.v2.houseAnalysis.addHouseAnalysis(input_params);

        ctx.success({ result });
    }

    async getUserHouseAnalysis() {

        const { ctx } = this;
        const input_params = ctx.query;
        const results = await ctx.service.house.v2.houseAnalysis.getMineHouseAnalysis(input_params);
        const format_rows = await ctx.service.house.v2.houseAnalysis.formatHouseAnalysis(results.rows);

        ctx.success({ page: results.page, count: results.count, results: format_rows });

    }

}

module.exports = HouseAnalysisController;
